/*
 * Decompiled with CFR 0.152.
 */
package com.sybit.airtable;

import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import com.sybit.airtable.Base;
import com.sybit.airtable.Configuration;
import com.sybit.airtable.GsonObjectMapper;
import com.sybit.airtable.converter.ListConverter;
import com.sybit.airtable.converter.MapConverter;
import com.sybit.airtable.exception.AirtableException;
import com.sybit.airtable.vo.Attachment;
import com.sybit.airtable.vo.Thumbnail;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Airtable {
    private static final Logger LOG = LoggerFactory.getLogger(Airtable.class);
    private static final String AIRTABLE_API_KEY = "AIRTABLE_API_KEY";
    private static final String AIRTABLE_BASE = "AIRTABLE_BASE";
    private Configuration config;

    public Airtable configure() throws AirtableException {
        return this.configure(new GsonObjectMapper());
    }

    public Airtable configure(ObjectMapper objectMapper) throws AirtableException {
        LOG.info("System-Property: Using Java property '-DAIRTABLE_API_KEY' to get apikey.");
        String airtableApi = System.getProperty(AIRTABLE_API_KEY);
        if (airtableApi == null) {
            LOG.info("Environment-Variable: Using OS environment 'AIRTABLE_API_KEY' to get apikey.");
            airtableApi = System.getenv(AIRTABLE_API_KEY);
        }
        if (airtableApi == null) {
            airtableApi = this.getCredentialProperty(AIRTABLE_API_KEY);
        }
        return this.configure(airtableApi, objectMapper);
    }

    public Airtable configure(String apiKey) throws AirtableException {
        return this.configure(apiKey, (ObjectMapper)new GsonObjectMapper());
    }

    public Airtable configure(String apiKey, ObjectMapper objectMapper) throws AirtableException {
        return this.configure(new Configuration(apiKey, "https://api.airtable.com/v0", null), objectMapper);
    }

    public Airtable configure(Configuration config) throws AirtableException {
        return this.configure(config, (ObjectMapper)new GsonObjectMapper());
    }

    public Airtable configure(Configuration config, ObjectMapper objectMapper) throws AirtableException {
        assert (config != null) : "config was null";
        assert (objectMapper != null) : "objectMapper was null";
        if (config.getApiKey() == null) {
            throw new AirtableException("Missing Airtable API-Key");
        }
        if (config.getEndpointUrl() == null) {
            throw new AirtableException("Missing endpointUrl");
        }
        this.config = config;
        if (config.getTimeout() != null) {
            LOG.info("Set connection timeout to: " + config.getTimeout() + "ms.");
            Unirest.setTimeouts((long)config.getTimeout(), (long)config.getTimeout());
        }
        this.configureProxy(config.getEndpointUrl());
        Unirest.setObjectMapper((ObjectMapper)objectMapper);
        DateConverter dtConverter = new DateConverter();
        dtConverter.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        ConvertUtils.register((Converter)dtConverter, Date.class);
        ListConverter lConverter = new ListConverter();
        lConverter.setListClass(Attachment.class);
        ConvertUtils.register((Converter)lConverter, List.class);
        MapConverter thConverter = new MapConverter();
        thConverter.setMapClass(Thumbnail.class);
        ConvertUtils.register((Converter)thConverter, Map.class);
        return this;
    }

    public void setProxy(String proxy) {
        this.config.setProxy(proxy);
        if (proxy == null) {
            Unirest.setProxy(null);
        } else {
            Unirest.setProxy((HttpHost)HttpHost.create((String)this.config.getProxy()));
        }
    }

    private void configureProxy(String endpointUrl) {
        if (this.config.getProxy() == null) {
            String httpProxy = System.getenv("http_proxy");
            String httpsProxy = System.getenv("https_proxy");
            if (httpsProxy != null && endpointUrl.contains("https")) {
                LOG.info("Use Proxy: Environment variable 'https_proxy' found and used: " + httpsProxy);
                this.setProxy(httpProxy);
            } else if (httpProxy != null && endpointUrl.contains("http")) {
                LOG.info("Use Proxy: Environment variable 'http_proxy' found and used: " + httpProxy);
                this.setProxy(httpsProxy);
            } else {
                this.setProxy(null);
            }
        } else if (endpointUrl.contains("127.0.0.1") || endpointUrl.contains("localhost")) {
            LOG.info("Use Proxy: ignored for 'localhost' and '127.0.0.1'");
            this.setProxy(null);
        } else {
            this.setProxy(this.config.getProxy());
        }
    }

    public Base base() throws AirtableException {
        LOG.info("Using Java property '-DAIRTABLE_BASE' to get key.");
        String val = System.getProperty(AIRTABLE_BASE);
        if (val == null) {
            LOG.info("Environment-Variable: Using OS environment 'AIRTABLE_BASE' to get base name.");
            val = System.getenv(AIRTABLE_BASE);
        }
        if (val == null) {
            val = this.getCredentialProperty(AIRTABLE_BASE);
        }
        return this.base(val);
    }

    public Base base(String base) throws AirtableException {
        if (base == null) {
            throw new AirtableException("base was null");
        }
        Base b = new Base(base, this);
        return b;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        assert (config != null) : "config was null";
        this.config = config;
        this.configureProxy(config.getEndpointUrl());
    }

    public String endpointUrl() {
        return this.config.getEndpointUrl();
    }

    public String apiKey() {
        return this.config.getApiKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCredentialProperty(String key) {
        String value;
        String file = "/credentials.properties";
        LOG.info("credentials file: Using file '/credentials.properties' using key '" + key + "' to get value.");
        InputStream in = null;
        try {
            Properties prop = new Properties();
            in = this.getClass().getResourceAsStream("/credentials.properties");
            prop.load(in);
            value = prop.getProperty(key);
        }
        catch (IOException | NullPointerException e) {
            try {
                LOG.error(e.getMessage(), (Throwable)e);
                value = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
        return value;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.config.setEndpointUrl(endpointUrl);
        this.configureProxy(endpointUrl);
    }
}

