/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.cloud.sb.broker.services.bosh.resources;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.swisscom.cloud.sb.broker.services.bosh.resources.GenericConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericConfig", generator="Immutables")
@Immutable
public final class ImmutableGenericConfig
implements GenericConfig {
    private final String templateName;
    private final String type;

    private ImmutableGenericConfig(String templateName, String type) {
        this.templateName = templateName;
        this.type = type;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public final ImmutableGenericConfig withTemplateName(String value) {
        String newValue = Objects.requireNonNull(value, "templateName");
        if (this.templateName.equals(newValue)) {
            return this;
        }
        return new ImmutableGenericConfig(newValue, this.type);
    }

    public final ImmutableGenericConfig withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableGenericConfig(this.templateName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericConfig && this.equalTo((ImmutableGenericConfig)another);
    }

    private boolean equalTo(ImmutableGenericConfig another) {
        return this.templateName.equals(another.templateName) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.templateName.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GenericConfig").omitNullValues().add("templateName", (Object)this.templateName).add("type", (Object)this.type).toString();
    }

    public static ImmutableGenericConfig copyOf(GenericConfig instance) {
        if (instance instanceof ImmutableGenericConfig) {
            return (ImmutableGenericConfig)instance;
        }
        return ImmutableGenericConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GenericConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEMPLATE_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String templateName;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GenericConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.templateName(instance.getTemplateName());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder templateName(String templateName) {
            this.templateName = Objects.requireNonNull(templateName, "templateName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGenericConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericConfig(this.templateName, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("templateName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build GenericConfig, some of required attributes are not set " + attributes;
        }
    }
}

