/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.cloud.sb.broker.servicedefinition;

import com.swisscom.cloud.sb.broker.model.CFService;
import com.swisscom.cloud.sb.broker.model.Plan;
import com.swisscom.cloud.sb.broker.repository.CFServiceRepository;
import com.swisscom.cloud.sb.broker.repository.ParameterRepository;
import com.swisscom.cloud.sb.broker.repository.PlanMetadataRepository;
import com.swisscom.cloud.sb.broker.repository.PlanRepository;
import com.swisscom.cloud.sb.broker.repository.ServiceInstanceRepository;
import com.swisscom.cloud.sb.broker.servicedefinition.ServiceDefinitionConfig;
import com.swisscom.cloud.sb.broker.servicedefinition.ServiceDefinitionProcessor;
import com.swisscom.cloud.sb.broker.servicedefinition.dto.ServiceDto;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDefinitionInitializer
implements GroovyObject {
    private static final Logger LOGGER;
    private CFServiceRepository cfServiceRepository;
    private PlanRepository planRepository;
    private PlanMetadataRepository planMetadataRepository;
    private ParameterRepository parameterRepository;
    private ServiceInstanceRepository serviceInstanceRepository;
    private ServiceDefinitionConfig serviceDefinitionConfig;
    private ServiceDefinitionProcessor serviceDefinitionProcessor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Autowired
    public ServiceDefinitionInitializer(CFServiceRepository cfServiceRepository, PlanRepository planRepository, PlanMetadataRepository planMetadataRepository, ParameterRepository parameterRepository, ServiceInstanceRepository serviceInstanceRepository, ServiceDefinitionConfig serviceDefinitionConfig, ServiceDefinitionProcessor serviceDefinitionProcessor) {
        ServiceDefinitionProcessor serviceDefinitionProcessor2;
        ServiceDefinitionConfig serviceDefinitionConfig2;
        ServiceInstanceRepository serviceInstanceRepository2;
        ParameterRepository parameterRepository2;
        PlanMetadataRepository planMetadataRepository2;
        PlanRepository planRepository2;
        CFServiceRepository cFServiceRepository;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cfServiceRepository = cFServiceRepository = cfServiceRepository;
        this.planRepository = planRepository2 = planRepository;
        this.planMetadataRepository = planMetadataRepository2 = planMetadataRepository;
        this.parameterRepository = parameterRepository2 = parameterRepository;
        this.serviceInstanceRepository = serviceInstanceRepository2 = serviceInstanceRepository;
        this.serviceDefinitionConfig = serviceDefinitionConfig2 = serviceDefinitionConfig;
        this.serviceDefinitionProcessor = serviceDefinitionProcessor2 = serviceDefinitionProcessor;
    }

    @PostConstruct
    private void init() {
        ArrayList<ServiceDto> arrayList = this.serviceDefinitionConfig.getServiceDefinitions();
        ArrayList<ServiceDto> cfServiceListFromConfig = DefaultTypeTransformation.booleanUnbox(arrayList) ? arrayList : new ArrayList<ServiceDto>();
        HashMap<String, CFService> cfServiceListFromDB = this.getServicesFromDB();
        this.synchroniseServiceDefinitions(cfServiceListFromConfig, cfServiceListFromDB);
    }

    private HashMap<String, CFService> getServicesFromDB() {
        Reference cfServiceMap = new Reference(new HashMap());
        List cfServiceList = this.cfServiceRepository.findAll();
        public final class _getServicesFromDB_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cfServiceMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getServicesFromDB_closure1(Object _outerInstance, Object _thisObject, Reference cfServiceMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.cfServiceMap = reference = cfServiceMap;
            }

            public Object doCall(Object cfService) {
                return ((HashMap)this.cfServiceMap.get()).put(((CFService)cfService).getGuid(), cfService);
            }

            @Generated
            public HashMap getCfServiceMap() {
                return (HashMap)ScriptBytecodeAdapter.castToType((Object)this.cfServiceMap.get(), HashMap.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getServicesFromDB_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)cfServiceList, (Closure)new _getServicesFromDB_closure1(this, this, cfServiceMap));
        return (HashMap)cfServiceMap.get();
    }

    private void synchroniseServiceDefinitions(List<ServiceDto> services, HashMap<String, CFService> toBeDeleted) {
        Reference toBeDeleted2 = new Reference(toBeDeleted);
        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((HashMap)toBeDeleted2.get()).size(), services.size()}, new String[]{"Start ServiceDefinition Synchronization (Is:", ",Should:", ")"})));
        public final class _synchroniseServiceDefinitions_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference toBeDeleted;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _synchroniseServiceDefinitions_closure2(Object _outerInstance, Object _thisObject, Reference toBeDeleted) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.toBeDeleted = reference = toBeDeleted;
            }

            public Object doCall(Object service) {
                LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ServiceDto)service).getName()}, new String[]{"Add or Update (name:", ")."})));
                ((ServiceDefinitionInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ServiceDefinitionInitializer.class)).addOrUpdateServiceDefinitions((ServiceDto)ScriptBytecodeAdapter.castToType((Object)service, ServiceDto.class));
                if (((HashMap)this.toBeDeleted.get()).containsKey(((ServiceDto)service).getGuid())) {
                    return ((HashMap)this.toBeDeleted.get()).remove(((ServiceDto)service).getGuid());
                }
                return null;
            }

            @Generated
            public HashMap getToBeDeleted() {
                return (HashMap)ScriptBytecodeAdapter.castToType((Object)this.toBeDeleted.get(), HashMap.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _synchroniseServiceDefinitions_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(services, (Closure)new _synchroniseServiceDefinitions_closure2(this, this, toBeDeleted2));
        public final class _synchroniseServiceDefinitions_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _synchroniseServiceDefinitions_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object service) {
                Reference service2 = new Reference(service);
                LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((CFService)service2.get()).getName()}, new String[]{"Delete/Disable Service (name:", ")"})));
                Reference canDeleteService = new Reference((Object)true);
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference service;
                    private /* synthetic */ Reference canDeleteService;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference service, Reference canDeleteService) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.service = reference2 = service;
                        this.canDeleteService = reference = canDeleteService;
                    }

                    public Object doCall(Plan plan) {
                        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((CFService)this.service.get()).getName(), plan.getName(), plan.getId()}, new String[]{"+ Delete/Disable Plan (serviceName:", ",name:", ",id:", ")"})));
                        Boolean bl = DefaultGroovyMethods.and((Boolean)((Boolean)ScriptBytecodeAdapter.castToType((Object)this.canDeleteService.get(), Boolean.class)), (Boolean)((ServiceDefinitionInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ServiceDefinitionInitializer.class)).tryDeletePlan(plan));
                        this.canDeleteService.set((Object)bl);
                        return bl;
                    }

                    public Object call(Plan plan) {
                        return this.doCall(plan);
                    }

                    @Generated
                    public Object getService() {
                        return this.service.get();
                    }

                    @Generated
                    public Object getCanDeleteService() {
                        return this.canDeleteService.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((List)DefaultGroovyMethods.toList((Iterable)((CFService)service2.get()).getPlans()), (Closure)new _closure4((Object)this, this.getThisObject(), service2, canDeleteService));
                CFService currentService = (CFService)ScriptBytecodeAdapter.castToType((Object)((ServiceDefinitionInitializer)this.getThisObject()).cfServiceRepository.getOne(((CFService)service2.get()).getId()), CFService.class);
                Boolean bl = (Boolean)canDeleteService.get();
                if (bl == null ? false : bl) {
                    LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{currentService.getName()}, new String[]{"DELETE Service (name:", ")"})));
                    ((ServiceDefinitionInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ServiceDefinitionInitializer.class)).deleteServiceHibernateCacheSavely(currentService);
                    return null;
                }
                LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{currentService.getName()}, new String[]{"DISABLE Service (name:", ")"})));
                boolean bl2 = false;
                currentService.setActive(Boolean.valueOf(bl2));
                return ((ServiceDefinitionInitializer)this.getThisObject()).cfServiceRepository.saveAndFlush(currentService);
            }

            public Object call(Object key, Object service) {
                Reference service2 = new Reference(service);
                return this.doCall(key, service2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _synchroniseServiceDefinitions_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Map)((HashMap)toBeDeleted2.get()), (Closure)new _synchroniseServiceDefinitions_closure3(this, this));
    }

    private void addOrUpdateServiceDefinitions(ServiceDto service) {
        this.serviceDefinitionProcessor.createOrUpdateServiceDefinitionFromYaml(service);
    }

    private boolean tryDeletePlan(Plan plan) {
        if (DefaultTypeTransformation.booleanUnbox(this.serviceInstanceRepository.findByPlan(plan))) {
            Boolean bl = plan.getActive();
            if (bl == null ? false : bl) {
                LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{plan.getService().getName(), plan.getName(), plan.getId()}, new String[]{"+ DISABLE Plan (serviceName:", ",name:", ",id:", ")"})));
                boolean bl2 = false;
                plan.setActive(Boolean.valueOf(bl2));
                this.planRepository.saveAndFlush(plan);
            }
            return false;
        }
        LOGGER.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{plan.getService().getName(), plan.getName(), plan.getId()}, new String[]{"+ DELETE Plan (serviceName:", ",name:", ",id:", ")"})));
        this.planRepository.delete(plan);
        this.planRepository.flush();
        CFService currentService = (CFService)ScriptBytecodeAdapter.castToType((Object)this.cfServiceRepository.getOne(plan.getService().getId()), CFService.class);
        currentService.getPlans().remove(plan);
        this.cfServiceRepository.saveAndFlush(currentService);
        return true;
    }

    private void deleteServiceHibernateCacheSavely(CFService service) {
        this.cfServiceRepository.delete(this.cfServiceRepository.findByGuid(service.getGuid()));
        this.cfServiceRepository.flush();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ServiceDefinitionInitializer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOGGER = logger = LoggerFactory.getLogger(ServiceDefinitionInitializer.class);
    }
}

