/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.results;

import com.google.gson.annotations.SerializedName;
import com.suse.salt.netapi.datatypes.StartTime;
import com.suse.salt.netapi.results.Result;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public class ResultInfo {
    @SerializedName(value="Function")
    private String function;
    @SerializedName(value="StartTime")
    private StartTime startTime;
    @SerializedName(value="Arguments")
    private List<Object> arguments;
    @SerializedName(value="Minions")
    private final HashSet<String> minions = new HashSet();
    @SerializedName(value="User")
    private String user;
    @SerializedName(value="Target")
    private String target;
    @SerializedName(value="Result")
    private HashMap<String, Result<Object>> rawResults;
    private final transient HashMap<String, Object> resultsCache = new HashMap();

    public List<Object> getArguments() {
        return this.arguments;
    }

    public String getFunction() {
        return this.function;
    }

    public Set<String> getMinions() {
        return this.minions;
    }

    public Date getStartTime(TimeZone tz) {
        return this.startTime == null ? null : this.startTime.getDate(tz);
    }

    public Date getStartTime() {
        return this.startTime == null ? null : this.startTime.getDate();
    }

    public String getTarget() {
        return this.target;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Object> getResult(String minion) {
        Result<Object> result;
        if (this.rawResults == null || (result = this.rawResults.get(minion)) == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(result.getResult());
    }

    public Map<String, Object> getResults() {
        if (this.rawResults == null || this.resultsCache.size() == this.rawResults.size()) {
            return this.resultsCache;
        }
        this.resultsCache.clear();
        this.resultsCache.putAll(this.rawResults);
        this.resultsCache.replaceAll((key, result) -> ((Result)result).getResult());
        return this.resultsCache;
    }

    public Set<String> getPendingMinions() {
        HashSet<String> pend = new HashSet<String>(this.minions);
        pend.removeAll(this.rawResults.keySet());
        return pend;
    }
}

