/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/job/(\\d{20})/ret/([^/]+)$");
    private final String jid;
    private final String minionId;
    private final Map<String, Object> data;

    public ResultEvent(String jid, String minionId, Map<String, Object> data) {
        this.jid = jid;
        this.minionId = minionId;
        this.data = data;
    }

    public String getJid() {
        return this.jid;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static Optional<ResultEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            ResultEvent result = new ResultEvent(matcher.group(1), matcher.group(2), event.getData());
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

