/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LocalCall<R>
implements Call<R> {
    private final String functionName;
    private final Optional<List<?>> arg;
    private final Optional<Map<String, ?>> kwarg;
    private final TypeToken<R> returnType;

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType) {
        this.functionName = functionName;
        this.arg = arg;
        this.kwarg = kwarg;
        this.returnType = returnType;
    }

    public TypeToken<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.functionName);
        this.arg.ifPresent(arg -> payload.put("arg", arg));
        this.kwarg.ifPresent(kwarg -> payload.put("kwarg", kwarg));
        return payload;
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Result wrapper = (Result)client.call(this, Client.LOCAL_ASYNC, "/", Optional.of(customArgs), new TypeToken<Result<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Result wrapper = (Result)client.call(this, Client.LOCAL_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Result<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public Map<String, R> callSync(SaltClient client, Target<?> target) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{type});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Result.class, new Type[]{listType});
        Result wrapper = (Result)client.call(this, Client.LOCAL, "/", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }

    public Map<String, R> callSync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        ParameterizedType mapType = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{mapType});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Result.class, new Type[]{listType});
        Result wrapper = (Result)client.call(this, Client.LOCAL, "/run", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }
}

