/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EngineEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/engines/([^/]+)/(.*)$");
    private static final Gson GSON = JsonParser.GSON;
    private final String engine;
    private final String timestamp;
    private final String additional;
    private final Optional<String> minionId;
    private final JsonElement data;

    private EngineEvent(String engine, String additional, String timestamp, Optional<String> minionId, JsonElement data) {
        this.engine = engine;
        this.additional = additional;
        this.timestamp = timestamp;
        this.minionId = minionId;
        this.data = data;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getMinionId() {
        return this.minionId;
    }

    public <R> R getData(TypeToken<R> type) {
        return (R)GSON.fromJson(this.data, type.getType());
    }

    public <R> R getData(Class<R> type) {
        return (R)GSON.fromJson(this.data, type);
    }

    public Map<String, Object> getData() {
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        return this.getData(typeToken);
    }

    public static Optional<EngineEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        JsonElement data = event.getData(JsonElement.class);
        if (matcher.matches() && data.isJsonObject()) {
            Optional<String> minionId = Optional.empty();
            JsonObject obj = data.getAsJsonObject();
            String timestamp = obj.get("_stamp").getAsString();
            if (obj.has("data") && obj.has("id")) {
                minionId = Optional.of(obj.get("id").getAsString());
                data = obj.get("data");
            } else {
                obj.remove("_stamp");
            }
            EngineEvent result = new EngineEvent(matcher.group(1), matcher.group(2), timestamp, minionId, data);
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

