/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchStartedEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/batch/([^/]+)/start$");
    private static final Gson GSON = JsonParser.GSON;
    private String jobId;
    private Data data;

    public BatchStartedEvent(String jobIdIn, Data dataIn) {
        this.jobId = jobIdIn;
        this.data = dataIn;
    }

    public Data getData() {
        return this.data;
    }

    public String getJobId() {
        return this.jobId;
    }

    public static Optional<BatchStartedEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            return Optional.of(new BatchStartedEvent(matcher.group(1), event.getData(Data.class)));
        }
        return Optional.empty();
    }

    public static class Data {
        @SerializedName(value="_stamp")
        private String timestamp;
        @SerializedName(value="available_minions")
        private List<String> availableMinions;
        @SerializedName(value="down_minions")
        private List<String> downMinions;
        private Optional<JsonElement> metadata = Optional.empty();

        public String getTimestamp() {
            return this.timestamp;
        }

        public List<String> getAvailableMinions() {
            return this.availableMinions;
        }

        public List<String> getDownMinions() {
            return this.downMinions;
        }

        public Optional<Object> getMetadata() {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, Object.class));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(Class<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(TypeToken<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType.getType()));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }
    }
}

