/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class Schedule {
    private Schedule() {
    }

    public static LocalCall<Result> delete(String name) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("name", name);
        return new LocalCall<Result>("schedule.delete", Optional.empty(), Optional.of(args), new TypeToken<Result>(){});
    }

    public static LocalCall<Result> add(String name, LocalCall<?> call, LocalDateTime once, Map<String, ?> metadata) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Map<String, Object> payload = call.getPayload();
        args.put("function", payload.get("fun"));
        args.put("job_args", payload.get("arg"));
        args.put("job_kwargs", payload.get("kwarg"));
        args.put("name", name);
        args.put("once", once.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        args.put("metadata", metadata);
        return new LocalCall<Result>("schedule.add", Optional.empty(), Optional.of(args), new TypeToken<Result>(){});
    }

    public static LocalCall<Map<String, Map<String, Object>>> list(boolean show_all) {
        LinkedHashMap<String, Boolean> args = new LinkedHashMap<String, Boolean>();
        args.put("show_all", show_all);
        args.put("return_yaml", false);
        return new LocalCall<Map<String, Map<String, Object>>>("schedule.list", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Map<String, Object>>>(){});
    }

    public static class Result {
        private String comment;
        private boolean result;

        public Result(String commentIn, boolean resultIn) {
            this.comment = commentIn;
            this.result = resultIn;
        }

        public boolean getResult() {
            return this.result;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

