/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.AbstractCall;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.datatypes.AuthMethod;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class RunnerCall<R>
extends AbstractCall<R> {
    private final Optional<Map<String, ?>> kwargs;

    public RunnerCall(String functionName, Optional<Map<String, ?>> kwargs, TypeToken<R> returnType) {
        super(functionName, returnType);
        this.kwargs = kwargs;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.getFunction());
        this.kwargs.ifPresent(kwargs -> payload.put("kwarg", kwargs));
        return payload;
    }

    public CompletionStage<RunnerAsyncResult<R>> callAsync(SaltClient client, AuthMethod auth) {
        return client.call(this, Client.RUNNER_ASYNC, Optional.empty(), Collections.emptyMap(), new TypeToken<Return<List<RunnerAsyncResult<R>>>>(){}, auth).thenApply(wrapper -> {
            RunnerAsyncResult result = (RunnerAsyncResult)((List)wrapper.getResult()).get(0);
            result.setType(this.getReturnType());
            return result;
        });
    }

    public CompletionStage<Result<R>> callSync(SaltClient client, AuthMethod auth) {
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{xor});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        CompletionStage<Result<R>> resultCompletionStage = client.call(this, Client.RUNNER, Optional.empty(), Collections.emptyMap(), TypeToken.get((Type)wrapperType), auth).thenApply(wrapper -> (Result)((List)wrapper.getResult()).get(0));
        return resultCompletionStage;
    }
}

