/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client.impl;

import com.suse.salt.netapi.client.AsyncHttpClient;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.exception.SaltUserUnauthorizedException;
import com.suse.salt.netapi.parser.JsonParser;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.client.HttpAsyncClient;

public class HttpAsyncClientImpl
implements AsyncHttpClient {
    private final HttpAsyncClient httpClient;

    public HttpAsyncClientImpl(HttpAsyncClient httpClientIn) {
        this.httpClient = httpClientIn;
    }

    @Override
    public <T> CompletionStage<T> post(URI uri, Map<String, String> headers, String data, JsonParser<T> parser) {
        return this.request(uri, headers, data, parser);
    }

    @Override
    public <T> CompletionStage<T> get(URI uri, Map<String, String> headers, JsonParser<T> parser) {
        return this.request(uri, headers, null, parser);
    }

    private <T> CompletionStage<T> request(URI uri, Map<String, String> headers, String data, JsonParser<T> parser) {
        return this.executeRequest(this.httpClient, this.prepareRequest(uri, headers, data), parser);
    }

    private <T> HttpUriRequest prepareRequest(URI uri, Map<String, String> headers, String jsonData) {
        HttpGet httpRequest;
        if (jsonData != null) {
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonData, ContentType.APPLICATION_JSON));
            httpRequest = httpPost;
        } else {
            httpRequest = new HttpGet(uri);
        }
        httpRequest.addHeader("Accept", "application/json");
        headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)httpRequest).addHeader(arg_0, arg_1));
        return httpRequest;
    }

    private <T> CompletionStage<T> executeRequest(HttpAsyncClient httpClient, HttpUriRequest httpRequest, final JsonParser<T> parser) {
        final CompletableFuture future = new CompletableFuture();
        httpClient.execute(httpRequest, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void completed(HttpResponse response) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 202) {
                    try {
                        Object result = parser.parse(response.getEntity().getContent());
                        future.complete(result);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                } else {
                    future.completeExceptionally(HttpAsyncClientImpl.this.createSaltException(statusCode));
                }
            }

            public void cancelled() {
                future.cancel(false);
            }
        });
        return future;
    }

    private SaltException createSaltException(int statusCode) {
        if (statusCode == 401) {
            return new SaltUserUnauthorizedException("Salt user does not have sufficient permissions");
        }
        return new SaltException("Response code: " + statusCode);
    }
}

