/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.suse.salt.netapi.errors.SaltError;
import com.suse.salt.netapi.parser.ResultSSHResultTypeAdapterFactory;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.utils.ClientUtils;
import com.suse.salt.netapi.utils.Xor;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ResultTypeAdapterFactory
implements TypeAdapterFactory {
    public <A> TypeAdapter<A> create(Gson gson, TypeToken<A> typeToken) {
        Type type = typeToken.getType();
        boolean isResult = typeToken.getRawType() == Result.class;
        boolean isParameterized = type instanceof ParameterizedType;
        boolean isSSHResult = ResultSSHResultTypeAdapterFactory.isResultSSHResult(type);
        if (isResult && isParameterized && !isSSHResult) {
            Type typeParam = ((ParameterizedType)type).getActualTypeArguments()[0];
            ParameterizedType xorType = ClientUtils.parameterizedType(null, Xor.class, new Type[]{SaltError.class, typeParam});
            TypeAdapter xorAdapter = gson.getAdapter(TypeToken.get((Type)xorType));
            return this.wrap((TypeAdapter<Xor>)xorAdapter);
        }
        return null;
    }

    private TypeAdapter<Result> wrap(final TypeAdapter<Xor> xorTypeAdapter) {
        return new TypeAdapter<Result>(){

            public Result read(JsonReader in) throws IOException {
                return new Result((Xor)xorTypeAdapter.read(in));
            }

            public void write(JsonWriter out, Result result) throws IOException {
                xorTypeAdapter.write(out, result.toXor());
            }
        };
    }
}

