/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Xor<L, R> {
    public static <L, R> Left<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Right<L, R> right(R value) {
        return new Right(value);
    }

    public abstract boolean isRight();

    public abstract boolean isLeft();

    public abstract <T> T fold(Function<? super L, ? extends T> var1, Function<? super R, ? extends T> var2);

    public abstract void consume(Consumer<? super L> var1, Consumer<? super R> var2);

    public abstract <T> Xor<L, T> map(Function<? super R, ? extends T> var1);

    public abstract <T> Xor<? super L, T> flatMap(Function<? super R, Xor<? super L, T>> var1);

    public abstract Optional<L> left();

    public abstract Optional<R> right();

    public abstract R orElse(R var1);

    public abstract R getOrElse(Supplier<? extends R> var1);

    public abstract boolean exists(Predicate<R> var1);

    public final Optional<R> option() {
        return this.right();
    }

    public static final class Right<L, R>
    extends Xor<L, R> {
        private final R right;

        private Right(R right) {
            this.right = right;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.of(this.right);
        }

        @Override
        public <T> Xor<L, T> map(Function<? super R, ? extends T> mapper) {
            return Right.right(mapper.apply(this.right));
        }

        @Override
        public <T> Xor<? super L, T> flatMap(Function<? super R, Xor<? super L, T>> mapper) {
            return mapper.apply(this.right);
        }

        public <T> Xor<T, R> leftMap(Function<? super L, Xor<T, R>> mapper) {
            return Right.right(this.right);
        }

        @Override
        public <T> T fold(Function<? super L, ? extends T> mapLeft, Function<? super R, ? extends T> mapRight) {
            return mapRight.apply(this.right);
        }

        @Override
        public void consume(Consumer<? super L> consumerLeft, Consumer<? super R> consumerRight) {
            consumerRight.accept(this.right);
        }

        @Override
        public boolean exists(Predicate<R> p) {
            return p.test(this.right);
        }

        @Override
        public R orElse(R value) {
            return this.right;
        }

        @Override
        public R getOrElse(Supplier<? extends R> supplier) {
            return this.right;
        }

        public String toString() {
            return "Right(" + this.right.toString() + ")";
        }

        public int hashCode() {
            return Objects.hash("Right", this.right);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.right, ((Right)obj).right);
        }
    }

    public static final class Left<L, R>
    extends Xor<L, R> {
        private final L left;

        private Left(L left) {
            this.left = left;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public Optional<L> left() {
            return Optional.of(this.left);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }

        @Override
        public <T> Xor<L, T> map(Function<? super R, ? extends T> mapper) {
            return Left.left(this.left);
        }

        @Override
        public <T> Xor<? super L, T> flatMap(Function<? super R, Xor<? super L, T>> mapper) {
            return Left.left(this.left);
        }

        public <T> Xor<T, R> leftMap(Function<? super L, Xor<T, R>> mapper) {
            return mapper.apply(this.left);
        }

        @Override
        public <T> T fold(Function<? super L, ? extends T> mapLeft, Function<? super R, ? extends T> mapRight) {
            return mapLeft.apply(this.left);
        }

        @Override
        public void consume(Consumer<? super L> consumerLeft, Consumer<? super R> consumerRight) {
            consumerLeft.accept(this.left);
        }

        @Override
        public boolean exists(Predicate<R> p) {
            return false;
        }

        @Override
        public R orElse(R value) {
            return value;
        }

        @Override
        public R getOrElse(Supplier<? extends R> supplier) {
            return supplier.get();
        }

        public String toString() {
            return "Left(" + this.left.toString() + ")";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.left, ((Left)obj).left);
        }

        public int hashCode() {
            return Objects.hash("Left", this.left);
        }
    }
}

