/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.runner;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.Data;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.calls.RunnerCall;
import com.suse.salt.netapi.calls.WheelAsyncResult;
import com.suse.salt.netapi.datatypes.StartTime;
import com.suse.salt.netapi.parser.JsonParser;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public class Jobs {
    private static final Gson GSON = JsonParser.GSON;

    private Jobs() {
    }

    public static RunnerCall<Map<String, Object>> lookupJid(String jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid);
        return new RunnerCall<Map<String, Object>>("jobs.lookup_jid", Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static <R> RunnerCall<Map<String, R>> lookupJid(LocalAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, jid.getType().getType()});
        return new RunnerCall<Map<String, R>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static <R> RunnerCall<Map<String, Data<R>>> lookupJid(WheelAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType dataType = ClientUtils.parameterizedType(null, Data.class, new Type[]{jid.getType().getType()});
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, dataType});
        return new RunnerCall<Map<String, Data<R>>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static <R> RunnerCall<Map<String, Data<R>>> lookupJid(RunnerAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType dataType = ClientUtils.parameterizedType(null, Data.class, new Type[]{jid.getType().getType()});
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, dataType});
        return new RunnerCall<Map<String, Data<R>>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static RunnerCall<Map<String, ListJobsEntry>> listJobs(Object searchMetadata) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("search_metadata", searchMetadata);
        return new RunnerCall<Map<String, ListJobsEntry>>("jobs.list_jobs", Optional.of(args), new TypeToken<Map<String, ListJobsEntry>>(){});
    }

    public static RunnerCall<Info> listJob(String jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid);
        return new RunnerCall<Info>("jobs.list_job", Optional.of(args), new TypeToken<Info>(){});
    }

    public static class ListJobsEntry {
        @SerializedName(value="Function")
        private String function;
        @SerializedName(value="StartTime")
        private StartTime startTime;
        @SerializedName(value="Arguments")
        private List<Object> arguments;
        @SerializedName(value="User")
        private String user;
        @SerializedName(value="Target")
        private Object target;

        public String getFunction() {
            return this.function;
        }

        public Date getStartTime(TimeZone tz) {
            return this.startTime == null ? null : this.startTime.getDate(tz);
        }

        public Date getStartTime() {
            return this.startTime == null ? null : this.startTime.getDate();
        }

        public List<Object> getArguments() {
            return this.arguments;
        }

        public String getUser() {
            return this.user;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    public static class Info {
        @SerializedName(value="Function")
        private String function;
        @SerializedName(value="StartTime")
        private StartTime startTime;
        @SerializedName(value="Arguments")
        private List<Object> arguments;
        @SerializedName(value="User")
        private String user;
        @SerializedName(value="Target")
        private Object target;
        @SerializedName(value="Minions")
        private List<String> minions;
        @SerializedName(value="Target-type")
        private String targetType;
        private String jid;
        @SerializedName(value="Metadata")
        private Optional<JsonElement> metadata = Optional.empty();
        @SerializedName(value="Result")
        private Map<String, JsonElement> result;

        public String getFunction() {
            return this.function;
        }

        public StartTime getStartTime() {
            return this.startTime;
        }

        public List<Object> getArguments() {
            return this.arguments;
        }

        public String getUser() {
            return this.user;
        }

        public Object getTarget() {
            return this.target;
        }

        public List<String> getMinions() {
            return this.minions;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public String getJid() {
            return this.jid;
        }

        public Optional<Object> getMetadata() {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, Object.class));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(Class<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(TypeToken<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType.getType()));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <T> Optional<T> getResult(String minionId, Class<T> type) {
            return Optional.ofNullable(this.result.get(minionId)).map(result -> {
                ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{type});
                Return r = (Return)GSON.fromJson(result, (Type)wrapperType);
                return r.getResult();
            });
        }

        public <T> Optional<T> getResult(String minionId, TypeToken<T> type) {
            return Optional.ofNullable(this.result.get(minionId)).map(result -> {
                ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{type.getType()});
                Return r = (Return)GSON.fromJson(result, (Type)wrapperType);
                return r.getResult();
            });
        }
    }
}

