/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client.impl;

import com.suse.salt.netapi.client.Connection;
import com.suse.salt.netapi.config.ClientConfig;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.exception.SaltUserUnauthorizedException;
import com.suse.salt.netapi.parser.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class HttpClientConnection<T>
implements Connection<T> {
    private final String endpoint;
    private final ClientConfig config;
    private final JsonParser<T> parser;

    public HttpClientConnection(String endpointIn, JsonParser<T> parserIn, ClientConfig configIn) {
        this.endpoint = endpointIn;
        this.config = configIn;
        this.parser = parserIn;
    }

    @Override
    public T getResult(String data) throws SaltException {
        return this.request(data);
    }

    @Override
    public T getResult() throws SaltException {
        return this.request(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T request(String data) throws SaltException {
        try (CloseableHttpClient httpClient = this.initializeHttpClient().build();){
            T t = this.executeRequest(httpClient, this.prepareRequest(data));
            return t;
        }
        catch (IOException e) {
            throw new SaltException(e);
        }
    }

    private HttpClientBuilder initializeHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        this.configureTimeouts(httpClientBuilder);
        this.configureProxyIfSpecified(httpClientBuilder);
        this.customizeHttpClient(httpClientBuilder);
        return httpClientBuilder;
    }

    protected void customizeHttpClient(HttpClientBuilder httpClientBuilder) {
    }

    private void configureTimeouts(HttpClientBuilder httpClientBuilder) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.get(ClientConfig.CONNECT_TIMEOUT).intValue()).setSocketTimeout(this.config.get(ClientConfig.SOCKET_TIMEOUT).intValue()).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
    }

    private void configureProxyIfSpecified(HttpClientBuilder httpClientBuilder) {
        String proxyHost = this.config.get(ClientConfig.PROXY_HOSTNAME);
        if (proxyHost != null) {
            int proxyPort = this.config.get(ClientConfig.PROXY_PORT);
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
            String proxyUsername = this.config.get(ClientConfig.PROXY_USERNAME);
            String proxyPassword = this.config.get(ClientConfig.PROXY_PASSWORD);
            if (proxyUsername != null && proxyPassword != null) {
                BasicCredentialsProvider credentials = new BasicCredentialsProvider();
                credentials.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentials);
            }
        }
    }

    private HttpUriRequest prepareRequest(String jsonData) throws UnsupportedEncodingException {
        HttpGet httpRequest;
        URI uri = this.config.get(ClientConfig.URL).resolve(this.endpoint);
        if (jsonData != null) {
            HttpPost httpPost = new HttpPost(uri);
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(jsonData));
            httpRequest = httpPost;
        } else {
            httpRequest = new HttpGet(uri);
        }
        httpRequest.addHeader("Accept", "application/json");
        String token = this.config.get(ClientConfig.TOKEN);
        if (token != null) {
            httpRequest.addHeader("X-Auth-Token", token);
        }
        return httpRequest;
    }

    private T executeRequest(CloseableHttpClient httpClient, HttpUriRequest httpRequest) throws SaltException, IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute(httpRequest);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 202) {
                T t = this.parser.parse(response.getEntity().getContent());
                return t;
            }
            try {
                throw this.createSaltException(statusCode);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private SaltException createSaltException(int statusCode) {
        if (statusCode == 401) {
            return new SaltUserUnauthorizedException("Salt user does not have sufficient permissions");
        }
        return new SaltException("Response code: " + statusCode);
    }
}

