package com.surveymonkey.surveymonkeyandroidsdk

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AlertDialog
import androidx.fragment.app.DialogFragment
import androidx.lifecycle.lifecycleScope
import com.surveymonkey.surveymonkeyandroidsdk.listener.DialogButtonClickListener
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants.DEBUG_TAG
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import org.json.JSONObject
import java.util.*

internal class SurveyDialogFragment: DialogFragment() {
    
    lateinit var surveyHash:String
    var customVariables: JSONObject? = null
    var requestCode: Int = 0

    lateinit var clickListener: DialogButtonClickListener

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setData()
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val inflater: LayoutInflater = layoutInflater
        val view = inflater.inflate(R.layout.fragment_dialog, null)
        val headerTextView =
            view.findViewById<View>(R.id.dialog_header_text_line) as TextView
        headerTextView.text = requireArguments().getString("dialog_header_text_line","")
        headerTextView.visibility = View.VISIBLE
        val messageTextView =
            view.findViewById<View>(R.id.dialog_first_text_line) as TextView
        messageTextView.text = requireArguments().getString("dialog_first_text_line","")
        messageTextView.visibility = View.VISIBLE
        return AlertDialog.Builder(requireContext())
            .setView(view)
            .setPositiveButton(getString(R.string.sm_action_give_feedback)) { _,_ ->
                val prefs = context?.getSharedPreferences(
                    SMConstants.PREF_NAME,
                    Context.MODE_PRIVATE)
                prefs?.edit()?.putLong(SMConstants.PROMPT_DATE, Date().time + requireArguments().getLong("after_accept_interval"))?.apply()

                Log.d(DEBUG_TAG,"is dialog show: ${dialog?.isShowing}")
                activity?.lifecycleScope?.launch(Dispatchers.Main) {
                    clickListener.onPositiveButtonClick(requestCode, surveyHash, customVariables)
                }
            }
            .setNegativeButton(R.string.sm_action_not_now){_,_ ->
                val prefs = context?.getSharedPreferences(SMConstants.PREF_NAME, Context.MODE_PRIVATE)
                prefs?.edit()
                    ?.putLong(SMConstants.PROMPT_DATE, Date().time + requireArguments().getLong("after_decline_interval"))
                    ?.apply()
            }
            .create()
    }

    private fun setData(){
        surveyHash = requireArguments().getString("survey_hash","")
        requestCode = requireArguments().getInt("request_code")
    }
}