package com.surveymonkey.surveymonkeyandroidsdk;

import static com.surveymonkey.surveymonkeyandroidsdk.utils.SMNetworkUtils.ConnectivityType;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;

import com.surveymonkey.surveymonkeyandroidsdk.listener.MediaSelectionListener;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTokenTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.RetrieveSPageTask;
import com.surveymonkey.surveymonkeyandroidsdk.utils.ImageFetcher;
import com.surveymonkey.surveymonkeyandroidsdk.utils.PermissionHandler;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMNetworkUtils;
import org.json.JSONException;
import org.json.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SMFeedbackFragment extends Fragment implements SMExceptionHandler, MediaSelectionListener {
    public final static String TAG = SMFeedbackFragment.class.getSimpleName();
    private static final int RESPONDENT_TOKEN_LOADER_KEY = 1;
    private static final int RESPONDENT_LOADER_KEY = 2;
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_HAS_LOADED_SPAGE_HTML = "smHasLoadedSPageHTML";
    private static final String SURVEY_STATUS = "survey_status";
    private static final String HTML = "html";
    private static final String COLLECTOR_CLOSED = "collector_closed";
    public static final String ABOUT_BLANK = "about:blank";
    private String mSPageHTML;
    private boolean mHasLoadedSPageWebView;
    private String mURL;
    private SMError mError;
    private String mTokenURL;
    private String mToken;
    private String mMasheryApiKey;
    private ProgressDialog mProgressDialog;
    private GetRespondentTokenTaskLoader getRespondentTokenTaskLoader;
    private GetRespondentTaskLoader getRespondentTaskLoader;
    private boolean mHasPreLoadedHTML;
    private Bundle mBundle;
    private ActivityResultLauncher<Intent> mediaARL;
    private ActivityResultLauncher<Uri> cameraARL;
    private ValueCallback<Uri[]> fileUploadCallback;
    private WebChromeClient.FileChooserParams fileChooseParams;
    private PermissionHandler mPermissionHandler;
    private ImageFetcher mImageFetcher;
    private Uri intent;
    private MediaSourceDialogFragment mDialog;

    public static SMFeedbackFragment newInstance(String url, String spageHTML, boolean hasLoadedHTML) {
        SMFeedbackFragment fragment = new SMFeedbackFragment();
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SM_SPAGE_URL, url);
        bundle.putString(KEY_SM_SPAGE_HTML, spageHTML);
        bundle.putBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML, hasLoadedHTML);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mHasLoadedSPageWebView = false;
        mSPageHTML = null;
        mBundle = this.getArguments();
        mediaARL = makeMediaRequestLauncher();
        cameraARL = makeCameraRequestLauncher();
        if (mBundle != null) {
            mURL = mBundle.getString(KEY_SM_SPAGE_URL);
            mHasPreLoadedHTML = mBundle.getBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML);
        }

        mPermissionHandler = new PermissionHandler(requireActivity());
        mImageFetcher = new ImageFetcher();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_smfeedback, container, false);
        mProgressDialog = ProgressDialog.show(getActivity(), null, getString(R.string.sm_loading_status));
        if (mHasPreLoadedHTML) {
            mSPageHTML = mBundle.getString(KEY_SM_SPAGE_HTML);
            loadSurveyPage();
        }
        else {
            @SuppressLint("StaticFieldLeak") RetrieveSPageTask sPageTask = new RetrieveSPageTask() {
                @Override
                protected void onPostExecute(JSONObject data) {
                    try {
                        if (data != null) {
                            JSONObject sdkData = data.getJSONObject(SURVEY_STATUS);
                            mSPageHTML = data.getString(HTML);
                            if (!sdkData.getBoolean(COLLECTOR_CLOSED)) {
                                loadSurveyPage();
                            } else {
                                //Collector is closed, so create fragment with no html so we can provide an error
                                handleCollectorClosed();
                            }
                        } else {
                            //Collector is closed, so start activity with no html so we can provide an error
                            handleCollectorClosed();
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                        if (mProgressDialog != null && mProgressDialog.isShowing()) {
                            mProgressDialog.dismiss();
                        }
                    }
                }
            };

            if (!SMNetworkUtils.getConnectivityType(requireContext()).equals(ConnectivityType.NO_CONNECTION.getValue())) {
                sPageTask.execute(mURL);
            } else {
                if (mProgressDialog != null && mProgressDialog.isShowing()) {
                    mProgressDialog.dismiss();
                }
                view.findViewById(R.id.sm_feedback_no_network).setVisibility(View.VISIBLE);
                view.findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
            }
        }
        return view.getRootView();
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!mHasLoadedSPageWebView && mSPageHTML != null) {
            loadSurveyPage();
        }
    }

    @Override
    public void onDestroy() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
        }

        if (getRespondentTaskLoader != null) {
            getRespondentTaskLoader.cancelLoad();
        }

        if (getRespondentTokenTaskLoader != null) {
            getRespondentTokenTaskLoader.cancelLoad();
        }

        super.onDestroy();
    }

    private void loadSurveyPage(){
        if (getView() != null) {
            mHasLoadedSPageWebView = true;
            WebView webView = getView().findViewById(R.id.sm_feedback_webview);
            webView.getSettings().setJavaScriptEnabled(true);
            webView.getSettings().setAllowFileAccess(true);
            webView.getSettings().setDomStorageEnabled(true);
            webView.setWebChromeClient(webChromeClient);
            webView.setWebViewClient(new SMWebviewClient());
            webView.loadDataWithBaseURL(mURL, mSPageHTML, null, "UTF-8", null);
        }
    }

    private void handleCollectorClosed(){
        mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
        Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
        handleError(mError);
    }


    public GetRespondentTokenTaskLoader onCreateRespondentTokenTaskLoader(int id, Bundle args) {
        getRespondentTokenTaskLoader = new GetRespondentTokenTaskLoader(getActivity(), mTokenURL, this);
        return getRespondentTokenTaskLoader;
    }

    public GetRespondentTaskLoader onCreateRespondentTaskLoader(int id, Bundle args) {
        getRespondentTaskLoader = new GetRespondentTaskLoader(getActivity(), mToken, mMasheryApiKey, this);
        return getRespondentTaskLoader;
    }

    public void onGetRespondentTokenTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                mToken = data.getString("respondent_token");
                mMasheryApiKey = data.getString("mashery_api_key");
                LoaderManager.getInstance(this).restartLoader(RESPONDENT_LOADER_KEY, null, new LoaderManager.LoaderCallbacks<JSONObject>() {
                    @Override
                    public Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                        return onCreateRespondentTaskLoader(id, args);
                    }

                    @Override
                    public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                        onGetRespondentTaskLoadFinished(loader, data);
                    }

                    @Override
                    public void onLoaderReset(Loader<JSONObject> loader) {
                    }
                });
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                handleError(mError);
            }
        }
        getRespondentTokenTaskLoader = null;
    }

    public void onGetRespondentTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                JSONObject result = data.getJSONObject("data");
                handleRespondent(result);
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                handleError(mError);
            }
        }
        getRespondentTaskLoader = null;
    }


    private void handleRespondent(JSONObject r) {
        try {
            if (getActivity() != null) {
                ((SMFeedbackFragmentListener) getActivity()).onFetchRespondentSuccess(r);
            }
        }
        catch (ClassCastException cce) {
            Log.d(SMConstants.DEBUG_TAG, "SMFeedbackFragmentListener has not been implemented");
            showEndOfSurveyOverlay();
        }
    }

    public void handleError(SMError e) {
        try {
            if (getActivity() != null) {
                ((SMFeedbackFragmentListener) getActivity()).onFetchRespondentFailure(e);
            }
        }
        catch (ClassCastException cce) {
            Log.d(SMConstants.DEBUG_TAG, "SMFeedbackFragmentListener has not been implemented");
            if (e.getErrorCode() == SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED.getValue()) {
                showSurveyClosedOverlay();
            }
            else {
                showEndOfSurveyOverlay();
            }
        }
    }

    private void showEndOfSurveyOverlay() {
        View v = getView();
        if (v != null) {
            v.findViewById(R.id.sm_feedback_survey_ended).setVisibility(View.VISIBLE);
            v.findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
        }
    }

    private void showSurveyClosedOverlay() {
        View v = getView();
        if (v != null) {
            v.findViewById(R.id.sm_feedback_survey_closed).setVisibility(View.VISIBLE);
            v.findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
        }
    }

    private void getToken() {
        if (getActivity() != null) {
            LoaderManager.getInstance(this).restartLoader(RESPONDENT_TOKEN_LOADER_KEY, null, new LoaderManager.LoaderCallbacks<JSONObject>() {
                @NonNull
                @Override
                public Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                    return onCreateRespondentTokenTaskLoader(id, args);
                }

                @Override
                public void onLoadFinished(@NonNull Loader<JSONObject> loader, JSONObject data) {
                    onGetRespondentTokenTaskLoadFinished(loader, data);
                }

                @Override
                public void onLoaderReset(@NonNull Loader<JSONObject> loader) {
                }
            });
        } else {
            Log.d(SMConstants.DEBUG_TAG, "getActivity is null in SMFeedbackFragment.getToken()");
        }
    }

    WebChromeClient webChromeClient = new WebChromeClient() {

        @Override
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
            fileUploadCallback = filePathCallback;
            fileChooseParams = fileChooserParams;
            mDialog = MediaSourceDialogFragment.newInstance(SMFeedbackFragment.this);
            mDialog.show(requireActivity().getSupportFragmentManager(), "");
            return true;
        }
    };

    protected ActivityResultLauncher<Intent> makeMediaRequestLauncher() {
        return registerForActivityResult(new ActivityResultContracts.StartActivityForResult(),
                result -> {
                    if (result.getResultCode() == Activity.RESULT_OK) {
                        fileUploadCallback.onReceiveValue(WebChromeClient.FileChooserParams.parseResult(result.getResultCode(), result.getData()));
                    } else {
                        fileUploadCallback.onReceiveValue(null);
                    }
                    fileUploadCallback = null;
                });
    }

    protected ActivityResultLauncher<Uri> makeCameraRequestLauncher() {
        return registerForActivityResult(new ActivityResultContracts.TakePicture(), success -> {
            if (success) {
                Log.d("", "camera result %s"+intent);
                fileUploadCallback.onReceiveValue(new Uri[]{intent});
            } else {
                fileUploadCallback.onReceiveValue(null);
            }
            fileUploadCallback = null;
        });
    }

    @Override
    public void onMediaOptionSelected(int position) {
        if (position == 1) {
            List<PermissionHandler.Permission> permissions = new ArrayList<>();
            permissions.add(new PermissionHandler.Permission().setType(Manifest.permission.CAMERA).
                    setDeniedMessageId(R.string.sm_permissions_camera_error_toast).
                    setRationaleMessageIds(R.string.sm_permissions_camera_rationale_title,
                            R.string.sm_permissions_camera_rationale));
            mPermissionHandler.setRequestPermissions(permissions);
            mPermissionHandler.request(listener);
        } else if (position == 2) {
            Intent intent = fileChooseParams.createIntent();
            mediaARL.launch(intent);
        }
    }

    PermissionHandler.Listener listener = new PermissionHandler.Listener() {
        @Override
        public void onGranted() {
            intent = mImageFetcher.openCamera(requireContext());
            if(null != intent) {
                cameraARL.launch(intent);
            } else {
                Toast.makeText(requireActivity(), getString(R.string.sm_permissions_camera_error_toast), Toast.LENGTH_SHORT).show();
            }
        }

        @Override
        public void onDenied(boolean showSettings) {
            if(showSettings) {
                Toast.makeText(requireActivity(), getString(R.string.sm_permissions_camera_denied_toast), Toast.LENGTH_SHORT).show();
            }
            fileUploadCallback.onReceiveValue(null);
        }
    };

    private class SMWebviewClient extends WebViewClient {

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            URL resourceURL = null;
            if (!mProgressDialog.isShowing()) {
                mProgressDialog.show();
            }
            try {
                if (!ABOUT_BLANK.equals(url)) {
                    resourceURL = new URL(url);
                }
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL != null && resourceURL.getPath() != null
                    && resourceURL.getPath().startsWith("/r/embed/sdk_token")) {
                view.stopLoading();
                // Clear webview to prevent misc json response from appearing
                view.loadUrl(ABOUT_BLANK);
                mTokenURL = url;
                getToken();
            } else {
                super.onPageStarted(view, url, favicon);
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            if (getActivity() != null && !(getActivity().isDestroyed())) {
                mProgressDialog.dismiss();
            }
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.contains("surveymonkey.com/r/")) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                startActivity(browserIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        mPermissionHandler.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}
