package com.surveymonkey.surveymonkeyandroidsdk.network

import com.google.gson.GsonBuilder
import com.surveymonkey.surveymonkeyandroidsdk.BuildConfig
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.util.concurrent.TimeUnit

internal object RetrofitHelper {
    private val httpLoggingInterceptor: HttpLoggingInterceptor = HttpLoggingInterceptor()
    private val okHttpClient = OkHttpClient.Builder()
        .readTimeout(60, TimeUnit.SECONDS)
        .addInterceptor(
            httpLoggingInterceptor.setLevel(
                if (BuildConfig.BUILD_TYPE != "release") {
                    HttpLoggingInterceptor.Level.BODY
                } else {
                    HttpLoggingInterceptor.Level.NONE
                }
            )
        )

        .connectTimeout(20, TimeUnit.SECONDS)
        .build()

    fun getRetrofitInstance(): Retrofit {
        val gsonBuilder = GsonBuilder().setLenient().create()
        return Retrofit.Builder().baseUrl(BuildConfig.SURVEY_BASE_URL)
            .client(okHttpClient)
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create(gsonBuilder))
            // we need to add converter factory to
            // convert JSON object to Java object
            .build()
    }
}