package com.surveymonkey.surveymonkeyandroidsdk.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;


public class SMQuestionResponse {
    public static final String PAGE_ID = "page_id";
    public static final String QUESTION_ID = "question_id";
    public static final String PAGE_INDEX = "page_index";
    public static final String QUESTION_INDEX = "question_index";
    public static final String QUESTION_VALUE = "question_value";
    public static final String ANSWERS = "answers";
    private String mPageID;
    private int mPageIndex;
    private String mQuestionID;
    private int mQuestionSurveyIndex;
    private String mQuestionValue;
    private ArrayList<SMAnswerResponse> mAnswers;

    /**
     * The SMQuestionResponse object represents a complete response to a given survey question.
     * <p>The SMQuestionResponse object includes relevant question attributes as well as an array of SMAnswerResponse objects representing representing the respondent’s answer(s) to this question.
     *
     * @param jsonObject The JSON representing a user's responses to a single question in the survey
     * @see SMRespondent
     */
    public SMQuestionResponse(JSONObject jsonObject) {
        try {
            mPageID = jsonObject.getString(PAGE_ID);
            mQuestionID = jsonObject.getString(QUESTION_ID);
            mPageIndex = jsonObject.getInt(PAGE_INDEX);
            mQuestionSurveyIndex = jsonObject.getInt(QUESTION_INDEX);
            mQuestionValue = jsonObject.getString(QUESTION_VALUE);
            ArrayList <SMAnswerResponse> answers = new ArrayList<>();
            JSONArray answersArray =  jsonObject.getJSONArray(ANSWERS);
            for (int i = 0; i< answersArray.length(); i++){
                SMAnswerResponse currentAnswer = new SMAnswerResponse(answersArray.getJSONObject(i));
                answers.add(currentAnswer);
            }
            mAnswers = answers;
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


    public String getPageID() {
        return mPageID;
    }

    public int getPageIndex() {
        return mPageIndex;
    }

    public String getQuestionID() {
        return mQuestionID;
    }

    public int getQuestionSurveyIndex() {
        return mQuestionSurveyIndex;
    }

    public String getQuestionValue() {
        return mQuestionValue;
    }

    public ArrayList<SMAnswerResponse> getAnswers() {
        return mAnswers;
    }

    public String getDescription() {
        int size = 0;
        if (mAnswers != null) {
            size = mAnswers.size();
        }
        return "<SMQuestionResponse: " + this +"; questionValue='" + mQuestionValue + "'; " + size + " answers>";
    }
}
