/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk.loaders;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import android.util.Log;
import com.surveymonkey.surveymonkeyandroidsdk.SMExceptionHandler;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class GetRespondentTokenTaskLoader
extends AsyncTaskLoader {
    private static final String RESPONDENT_TOKEN = "respondent_token";
    private static final String MASHERY_API_KEY = "mashery_api_key";
    private static final String ERROR = "error";
    private static final String USER_EXITED_SURVEY = "user_exited_survey";
    private String mResponse;
    private String mUrl;
    private SMError mError;
    private String mToken;
    private SMExceptionHandler mExceptionHandler;

    public GetRespondentTokenTaskLoader(Context context, String url, SMExceptionHandler handler) {
        super(context);
        this.mUrl = url;
        this.mExceptionHandler = handler;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.takeContentChanged() || this.mResponse == null) {
            this.forceLoad();
        }
        if (this.getResponse() != null) {
            this.deliverResult(this.getResponse());
        }
    }

    private String getResponse() {
        return this.mResponse;
    }

    public JSONObject loadInBackground() throws SMError {
        try {
            return this.retrieveRespondentToken(this.mUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject retrieveRespondentToken(String inputURL) throws IOException, JSONException, SMError {
        try (InputStream is = null;){
            URL url = new URL(inputURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.connect();
            this.handleResponseCode(conn.getResponseCode(), conn);
            is = conn.getInputStream();
            JSONObject contentAsJSON = this.readIt(is);
            try {
                JSONObject returnJSON = new JSONObject();
                returnJSON.put(RESPONDENT_TOKEN, contentAsJSON.get(RESPONDENT_TOKEN));
                returnJSON.put(MASHERY_API_KEY, contentAsJSON.get(MASHERY_API_KEY));
                JSONObject jSONObject = returnJSON;
                return jSONObject;
            }
            catch (JSONException e) {
                JSONObject jSONObject;
                block9: {
                    JSONObject errDict = contentAsJSON.getJSONObject(ERROR);
                    if (errDict.getString("reason").equals(USER_EXITED_SURVEY)) {
                        this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RESPONDENT_EXITED_SURVEY, null);
                        Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                        this.mExceptionHandler.handleError(this.mError);
                    } else {
                        this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, null);
                        Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                        this.mExceptionHandler.handleError(this.mError);
                    }
                    jSONObject = null;
                    if (is == null) break block9;
                    is.close();
                }
                return jSONObject;
            }
        }
    }

    private JSONObject readIt(InputStream stream) throws IOException {
        String inputStr;
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder responseStrBuilder = new StringBuilder();
        while ((inputStr = streamReader.readLine()) != null) {
            responseStrBuilder.append(inputStr);
        }
        try {
            return new JSONObject(responseStrBuilder.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void handleResponseCode(int statusCode, HttpURLConnection connection) throws SMError {
        if (statusCode != 200) {
            switch (statusCode) {
                case 404: {
                    this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_SURVEY_DELETED, null);
                    Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                    connection.disconnect();
                    this.mExceptionHandler.handleError(this.mError);
                }
                case 410: {
                    this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_NONEXISTENT_LINK, null);
                    Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                    connection.disconnect();
                    this.mExceptionHandler.handleError(this.mError);
                }
            }
            this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_INTERNAL_SERVER_ERROR, null);
            Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
            connection.disconnect();
            this.mExceptionHandler.handleError(this.mError);
        }
    }
}

