package com.surveymonkey.surveymonkeyandroidsdk.loaders;

import android.content.Context;
import android.util.Log;

import com.surveymonkey.surveymonkeyandroidsdk.SMExceptionHandler;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

public class GetRespondentTaskLoader extends android.support.v4.content.AsyncTaskLoader {

    private static final String RESPONDENT_URL = "https://api.surveymonkey.net/sdk/v1/respondents?api_key=";

    private String mToken;
    private String mMasheryApiKey;
    private JSONObject mResponse;
    private SMError mError;
    private SMExceptionHandler mExceptionHandler;

    public GetRespondentTaskLoader(Context context, String token, String masheryApiKey, SMExceptionHandler handler) {
        super(context);
        mToken = token;
        mMasheryApiKey = masheryApiKey;
        mExceptionHandler = handler;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (takeContentChanged() || mResponse == null) {
            forceLoad();
        }
        if (getResponse() != null) {
            deliverResult(getResponse());
        }
    }

    private JSONObject getResponse() {
        return mResponse;
    }

    @Override
    public JSONObject loadInBackground() throws SMError {
        try {
            mResponse = makeRespondentRequest(mToken);
            return mResponse;
        } catch (IOException e) {
            mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, null);
            Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
            mExceptionHandler.handleError(mError);
            return null;
        }
    }

    private JSONObject makeRespondentRequest(String token) throws IOException {
        InputStream is = null;
        try {
            URL url = new URL(RESPONDENT_URL + mMasheryApiKey);
            String tokenString = "bearer " + token;
            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setReadTimeout(10000 /* milliseconds */);
            conn.setConnectTimeout(15000 /* milliseconds */);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setRequestProperty("Authorization", tokenString);
            conn.connect();
            handleResponseCode(conn.getResponseCode(), conn);
            is = conn.getInputStream();
            JSONObject content = readIt(is);
            return content;
        } finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private JSONObject readIt(InputStream stream) throws IOException {
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder responseStrBuilder = new StringBuilder();
        String inputStr;
        while ((inputStr = streamReader.readLine()) != null) {
            responseStrBuilder.append(inputStr);
        }
        try {
            return new JSONObject(responseStrBuilder.toString());
        } catch (JSONException e) {
            mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RESPONSE_PARSE_FAILED, e);
            Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
            mExceptionHandler.handleError(mError);
            return null;        }
    }

    private void handleResponseCode(int statusCode, HttpURLConnection connection) {
        if (statusCode != 200) {
            switch (statusCode) {
                case 403:
                    mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RESPONSE_LIMIT_HIT, null);
                    Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                    connection.disconnect();
                    mExceptionHandler.handleError(mError);
                case 500:
                    mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_INTERNAL_SERVER_ERROR, null);
                    Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                    connection.disconnect();
                    mExceptionHandler.handleError(mError);
                default:
                    mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_INTERNAL_SERVER_ERROR, null);
                    Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                    connection.disconnect();
                    mExceptionHandler.handleError(mError);
            }
        }
    }
}
