package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTokenTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.RetrieveSPageTask;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;

import org.json.JSONException;
import org.json.JSONObject;

import java.net.MalformedURLException;
import java.net.URL;


public class SMFeedbackFragment extends Fragment {
    public final static String TAG = SMFeedbackFragment.class.getSimpleName();
    private static final int RESPONDENT_TOKEN_LOADER_KEY = 1;
    private static final int RESPONDENT_LOADER_KEY = 2;

    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_HAS_LOADED_SPAGE_HTML = "smHasLoadedSPageHTML";
    private static final String SURVEY_STATUS = "survey_status";
    private static final String HTML = "html";
    private static final String COLLECTOR_CLOSED = "collector_closed";


    private WebView mWebView;
    private String mSPageHTML;
    private boolean mHasPreLoadedHTML;
    private boolean mHasLoadedSPageWebView;
    private String mURL;
    private SMError mError;
    private String mTokenURL;
    private String mToken;
    private String mMasheryApiKey;
    private ProgressDialog mProgressDialog;
    private ConnectivityMonitor connectivityMonitor;


    public static SMFeedbackFragment newInstance(String url, String spageHTML, boolean hasLoadedHTML) {
        SMFeedbackFragment fragment = new SMFeedbackFragment();
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SM_SPAGE_URL, url);
        bundle.putString(KEY_SM_SPAGE_HTML, spageHTML);
        bundle.putBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML, hasLoadedHTML);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mHasPreLoadedHTML = false;
        mHasLoadedSPageWebView = false;
        mSPageHTML = null;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            mURL = bundle.getString(KEY_SM_SPAGE_URL);
            mHasPreLoadedHTML = bundle.getBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML);
            if (mHasPreLoadedHTML) {
                mSPageHTML = bundle.getString(KEY_SM_SPAGE_HTML);
                loadSurveyPage();
            }
            else {
                RetrieveSPageTask sPageTask = new RetrieveSPageTask() {
                    @Override
                    protected void onPostExecute(JSONObject data) {
                        try {
                            if (data != null) {
                                JSONObject sdkData = data.getJSONObject(SURVEY_STATUS);
                                mSPageHTML = data.getString(HTML);
                                if (!sdkData.getBoolean(COLLECTOR_CLOSED)) {
                                    loadSurveyPage();

                                } else {
                                    //Collector is closed, so create fragment with no html so we can provide an error
                                    handleCollectorClosed();
                                }
                            } else {
                                //Collector is closed, so start activity with no html so we can provide an error
                                handleCollectorClosed();
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                };
                sPageTask.execute(mURL);
            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_smfeedback, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        connectivityMonitor = new ConnectivityMonitor();
        getActivity().registerReceiver(connectivityMonitor, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
        Thread.setDefaultUncaughtExceptionHandler(new SMExceptionHandler(this));
        if (!mHasLoadedSPageWebView && mSPageHTML != null) {
            loadSurveyPage();
        }

    }


    @Override
    public void onDestroy() {
        getActivity().unregisterReceiver(connectivityMonitor);
        super.onDestroy();
    }

    private void loadSurveyPage(){
        if (getView() != null) {
            mProgressDialog = ProgressDialog.show(getActivity(), null, getString(R.string.sm_loading_status));
            mHasLoadedSPageWebView = true;
            mWebView = (WebView) getView().findViewById(R.id.sm_feedback_webview);
            mWebView.getSettings().setJavaScriptEnabled(true);
            mWebView.setWebViewClient(new SMWebviewClient());
            mWebView.loadDataWithBaseURL(mURL, mSPageHTML, null, "UTF-8", null);
        }

    }

    private void handleCollectorClosed(){
        mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
        Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
        handleError(mError);
    }


    public android.support.v4.content.Loader<JSONObject> onCreateRespondentTokenTaskLoader(int id, Bundle args) {
        return new GetRespondentTokenTaskLoader(getActivity(), mTokenURL);
    }

    public android.support.v4.content.Loader<JSONObject> onCreateRespondentTaskLoader(int id, Bundle args) {
        return new GetRespondentTaskLoader(getActivity(), mToken, mMasheryApiKey);
    }

    public void onGetRespondentTokenTaskLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                mToken = data.getString("respondent_token");
                mMasheryApiKey = data.getString("mashery_api_key");
                GetRespondentTaskLoader respondentTaskLoader = (GetRespondentTaskLoader) getActivity().getSupportLoaderManager().getLoader(RESPONDENT_LOADER_KEY);
                if (respondentTaskLoader != null) {
                    getActivity().getSupportLoaderManager().initLoader(RESPONDENT_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                        @Override
                        public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                            return onCreateRespondentTaskLoader(id, args);
                        }

                        @Override
                        public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                            onGetRespondentTaskLoadFinished(loader, data);
                        }

                        @Override
                        public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                        }
                    });
                }
                getActivity().getSupportLoaderManager().restartLoader(RESPONDENT_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                    @Override
                    public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                        return onCreateRespondentTaskLoader(id, args);
                    }

                    @Override
                    public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                        onGetRespondentTaskLoadFinished(loader, data);
                    }

                    @Override
                    public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                    }
                });
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                throw mError;
            }
        }
    }

    public void onGetRespondentTaskLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                JSONObject result = data.getJSONObject("data");
                handleRespondent(result);
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                throw mError;
            }
        }
    }


    private void handleRespondent(JSONObject r) {
        try {
            ((SMFeedbackFragmentListener) getActivity()).onFetchRespondentSuccess(r);
        }
        catch (ClassCastException cce) {
            Log.d(SMConstants.DEBUG_TAG, "SMFeedbackFragmentListener has not been implemented");
            showEndOfSurveyOverlay();
        }
    }

    private void handleError(SMError e) {
        try {
            ((SMFeedbackFragmentListener) getActivity()).onFetchRespondentFailure(e);
        }
        catch (ClassCastException cce) {
            Log.d(SMConstants.DEBUG_TAG, "SMFeedbackFragmentListener has not been implemented");
            if (e.getErrorCode() == SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED.getValue()) {
                showSurveyClosedOverlay();
            }
            else {
                showEndOfSurveyOverlay();
            }
        }
    }

    private void showEndOfSurveyOverlay() {
        getView().findViewById(R.id.sm_feedback_survey_ended).setVisibility(View.VISIBLE);
        getView().findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
    }

    private void showSurveyClosedOverlay() {
        getView().findViewById(R.id.sm_feedback_survey_closed).setVisibility(View.VISIBLE);
        getView().findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
    }

    private void getToken() {
        GetRespondentTokenTaskLoader loader = (GetRespondentTokenTaskLoader) getActivity().getSupportLoaderManager().getLoader(2);
        if (loader != null) {
            getActivity().getSupportLoaderManager().initLoader(RESPONDENT_TOKEN_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                @Override
                public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                    return onCreateRespondentTokenTaskLoader(id, args);
                }

                @Override
                public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                    onGetRespondentTokenTaskLoadFinished(loader, data);
                }

                @Override
                public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                }
            });
        }
        getActivity().getSupportLoaderManager().restartLoader(RESPONDENT_TOKEN_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
            @Override
            public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                return onCreateRespondentTokenTaskLoader(id, args);
            }

            @Override
            public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                onGetRespondentTokenTaskLoadFinished(loader, data);
            }

            @Override
            public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
            }
        });
    }


    private class SMWebviewClient extends WebViewClient {

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/embed/sdk_token")) {
                view.stopLoading();
                mTokenURL = url;
                getToken();
            } else {
                super.onPageStarted(view, url, favicon);
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/")) {
                mProgressDialog.dismiss();
            }
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.contains("surveymonkey.com/r/")) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                startActivity(browserIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }

    protected class SMExceptionHandler implements
            java.lang.Thread.UncaughtExceptionHandler {

        public SMExceptionHandler(Fragment context) {
        }

        public void uncaughtException(Thread thread, Throwable exception) {
            SMError cause = (SMError) exception.getCause();
            handleError(cause);
        }
    }


    public static class ConnectivityMonitor extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            if (!isNetworkConnected(context)) {
                ((FragmentActivity) context).getSupportFragmentManager().findFragmentByTag(SMFeedbackFragment.TAG).getView().findViewById(R.id.sm_feedback_no_network).setVisibility(View.VISIBLE);
                ((FragmentActivity) context).getSupportFragmentManager().findFragmentByTag(SMFeedbackFragment.TAG).getView().findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
            } else {
                ((FragmentActivity) context).getSupportFragmentManager().findFragmentByTag(SMFeedbackFragment.TAG).getView().findViewById(R.id.sm_feedback_no_network).setVisibility(View.GONE);
                ((FragmentActivity) context).getSupportFragmentManager().findFragmentByTag(SMFeedbackFragment.TAG).getView().findViewById(R.id.sm_feedback_webview).setVisibility(View.VISIBLE);
            }
        }

        public boolean isNetworkConnected(Context context) {
            ConnectivityManager manager = (ConnectivityManager) ((FragmentActivity) context).getSupportFragmentManager().findFragmentByTag(SMFeedbackFragment.TAG).getActivity().getApplication().getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetInfo = manager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.isConnected();
        }

    }

}
