package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;

import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;

import org.json.JSONObject;


public class SMFeedbackActivity extends FragmentActivity implements SMFeedbackFragmentListener {

    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_ERROR = "smError";
    public static final String KEY_SM_DESCRIPTION = "smDescription";

    public static final String SM_RESPONDENT = "smRespondent";
    public static final String SM_ERROR_CODE = "smErrorCode";

    private String mSPageHTML;
    private String mURL;
    private SMError mError;


    public static void startActivityForResult(Activity context, int requestCode, String url, String sPageHTML) {
        Intent intent = new Intent(context, SMFeedbackActivity.class);
        if (sPageHTML != null) {
            intent.putExtra(KEY_SM_SPAGE_HTML, sPageHTML);
        }
        intent.putExtra(KEY_SM_SPAGE_URL, url);
        context.startActivityForResult(intent, requestCode);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        mSPageHTML = intent.getStringExtra(KEY_SM_SPAGE_HTML);
        if (mSPageHTML == null) {
            mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
            Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
            onFetchRespondentFailure(mError);
        }
        mURL = intent.getStringExtra(KEY_SM_SPAGE_URL);
        if (savedInstanceState == null) {
            getSupportFragmentManager().beginTransaction().add(android.R.id.content, SMFeedbackFragment.newInstance(mURL, mSPageHTML, true), SMFeedbackFragment.TAG).commit();
        }
    }


    @Override
    public void onBackPressed() {
        mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_USER_CANCELED, null);
        Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
        onFetchRespondentFailure(mError);
    }

    public void onFetchRespondentSuccess(JSONObject respondent) {
        Intent intent = new Intent();
        intent.putExtra(SM_RESPONDENT, respondent.toString());
        setResult(RESULT_OK, intent);
        finish();
    }

    public void onFetchRespondentFailure(SMError e) {
        Intent intent = new Intent();
        intent.putExtra(KEY_SM_ERROR, e);
        if (e != null) {
            intent.putExtra(KEY_SM_DESCRIPTION, e.getDescription());
            intent.putExtra(SM_ERROR_CODE, e.getErrorCode());
        } else {
            intent.putExtra(KEY_SM_DESCRIPTION, "");
            intent.putExtra(SM_ERROR_CODE, -1);
        }
        setResult(RESULT_CANCELED, intent);
        finish();
    }

}
