package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTokenTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;

import org.json.JSONException;
import org.json.JSONObject;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;


public class SMFeedbackActivity extends FragmentActivity {
    private static final int RESPONDENT_TOKEN_LOADER_KEY = 1;
    private static final int RESPONDENT_LOADER_KEY = 2;

    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_ERROR = "smError";
    public static final String KEY_SM_DESCRIPTION = "smDescription";

    public static final String SM_RESPONDENT = "smRespondent";
    public static final String SM_ERROR_CODE = "smErrorCode";

    private WebView mWebView;
    private String mSPageHTML;
    private String mURL;
    private SMError mError;
    private String mTokenURL;
    private String mToken;
    private String mMasheryApiKey;
    private ProgressDialog mProgressDialog;
    private ConnectivityMonitor connectivityMonitor;


    public static void startActivityForResult(Activity context, int requestCode, String url, String sPageHTML) {
        Intent intent = new Intent(context, SMFeedbackActivity.class);
        if (sPageHTML != null) {
            intent.putExtra(KEY_SM_SPAGE_HTML, sPageHTML);
        }
        intent.putExtra(KEY_SM_SPAGE_URL, url);
        context.startActivityForResult(intent, requestCode);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        connectivityMonitor = new ConnectivityMonitor();
        registerReceiver(connectivityMonitor, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
        Thread.setDefaultUncaughtExceptionHandler(new SMExceptionHandler(this));
        Intent intent = getIntent();
        mSPageHTML = intent.getStringExtra(KEY_SM_SPAGE_HTML);
        if (mSPageHTML == null) {
            mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
            Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
            handleError(mError);
        }
        mProgressDialog = ProgressDialog.show(this, null, getString(R.string.loading_status));
        mURL = intent.getStringExtra(KEY_SM_SPAGE_URL);
        setContentView(R.layout.activity_smfeedback);
        mWebView = (WebView) findViewById(R.id.sm_feedback_webview);
        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.setWebViewClient(new SMWebviewClient());
        mWebView.loadDataWithBaseURL(mURL, mSPageHTML, null, "UTF-8", null);
    }


    @Override
    protected void onDestroy()
    {
        unregisterReceiver(connectivityMonitor);
        super.onDestroy();
    }

    @Override
    public void onBackPressed() {
        mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_USER_CANCELED, null);
        Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
        handleError(mError);

    }


    public android.support.v4.content.Loader<JSONObject> onCreateRespondentTokenTaskLoader(int id, Bundle args) {
        return new GetRespondentTokenTaskLoader(this, mTokenURL);
    }

    public android.support.v4.content.Loader<JSONObject> onCreateRespondentTaskLoader(int id, Bundle args) {
        return new GetRespondentTaskLoader(this, mToken, mMasheryApiKey);
    }

    public void onGetRespondentTokenTaskLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                mToken = data.getString("respondent_token");
                mMasheryApiKey = data.getString("mashery_api_key");
                GetRespondentTaskLoader respondentTaskLoader = (GetRespondentTaskLoader) getSupportLoaderManager().getLoader(RESPONDENT_LOADER_KEY);
                if (respondentTaskLoader != null) {
                    getSupportLoaderManager().initLoader(RESPONDENT_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                        @Override
                        public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                            return onCreateRespondentTaskLoader(id, args);
                        }

                        @Override
                        public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                            onGetRespondentTaskLoadFinished(loader, data);
                        }

                        @Override
                        public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                        }
                    });
                }
                getSupportLoaderManager().restartLoader(RESPONDENT_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                    @Override
                    public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                        return onCreateRespondentTaskLoader(id, args);
                    }

                    @Override
                    public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                        onGetRespondentTaskLoadFinished(loader, data);
                    }

                    @Override
                    public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                    }
                });
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                throw mError;
            }
        }
    }

    public void onGetRespondentTaskLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                JSONObject result = data.getJSONObject("data");
                handleRespondent(result);
            } catch (JSONException e) {
                mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, e);
                Log.d(SMConstants.DEBUG_TAG, mError.getDescription());
                throw mError;
            }
        }
    }


    private void handleRespondent(JSONObject r) {
        Intent intent = new Intent();
        intent.putExtra(SM_RESPONDENT, r.toString());
        setResult(RESULT_OK, intent);
        finish();
    }

    private void handleError(SMError e) {
        Intent intent = new Intent();
        intent.putExtra(KEY_SM_ERROR, e);
        if (e != null) {
            intent.putExtra(KEY_SM_DESCRIPTION, e.getDescription());
            intent.putExtra(SM_ERROR_CODE, e.getErrorCode());
        } else {
            intent.putExtra(KEY_SM_DESCRIPTION, "");
            intent.putExtra(SM_ERROR_CODE, -1);
        }
        setResult(RESULT_CANCELED, intent);
        finish();
    }

    private void getToken() {
        GetRespondentTokenTaskLoader loader = (GetRespondentTokenTaskLoader) getSupportLoaderManager().getLoader(2);
        if (loader != null) {
            getSupportLoaderManager().initLoader(RESPONDENT_TOKEN_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
                @Override
                public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                    return onCreateRespondentTokenTaskLoader(id, args);
                }

                @Override
                public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                    onGetRespondentTokenTaskLoadFinished(loader, data);
                }

                @Override
                public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
                }
            });
        }
        getSupportLoaderManager().restartLoader(RESPONDENT_TOKEN_LOADER_KEY, null, new android.support.v4.app.LoaderManager.LoaderCallbacks<JSONObject>() {
            @Override
            public android.support.v4.content.Loader<JSONObject> onCreateLoader(int id, Bundle args) {
                return onCreateRespondentTokenTaskLoader(id, args);
            }

            @Override
            public void onLoadFinished(android.support.v4.content.Loader<JSONObject> loader, JSONObject data) {
                onGetRespondentTokenTaskLoadFinished(loader, data);
            }

            @Override
            public void onLoaderReset(android.support.v4.content.Loader<JSONObject> loader) {
            }
        });
    }


    private class SMWebviewClient extends WebViewClient {

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/embed/sdk_token")) {
                view.stopLoading();
                mTokenURL = url;
                getToken();
            } else {
                super.onPageStarted(view, url, favicon);
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/")) {
                mProgressDialog.dismiss();
            }
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.contains("surveymonkey.com/r/")) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                startActivity(browserIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }

    protected class SMExceptionHandler implements
            java.lang.Thread.UncaughtExceptionHandler {

        public SMExceptionHandler(Activity context) {
        }

        public void uncaughtException(Thread thread, Throwable exception) {
            SMError cause = (SMError) exception.getCause();
            handleError(cause);
        }

    }


    public static class ConnectivityMonitor extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            if (!isNetworkConnected(context)) {
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_no_network).setVisibility(View.VISIBLE);
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_webview).setVisibility(View.GONE);
            }
            else {
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_no_network).setVisibility(View.GONE);
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_webview).setVisibility(View.VISIBLE);
            }
        }

        public boolean isNetworkConnected(Context context) {
            ConnectivityManager manager = (ConnectivityManager) ((SMFeedbackActivity)context).getApplication().getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetInfo = manager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.isConnected();
        }

    }

}
