/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.mes.nfc.controller;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.ToastUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NFCHelper {
    private NfcAdapter mNfcAdapter;
    private PendingIntent mPendingIntent;
    private OnNFCListener onNFCListener;

    private NFCHelper() {
    }

    public static NFCHelper getInstance() {
        return NFCHelperHolder.INSTANCE;
    }

    public void setup(Context context) {
        if (!this.checkNFC(context)) {
            return;
        }
        this.mPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)new Intent(context, context.getClass()), (int)0);
    }

    public void release() {
        this.mPendingIntent = null;
    }

    public boolean checkNFC(Context context) {
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        if (this.mNfcAdapter == null) {
            ToastUtils.show((Context)context, (String)"\u8bbe\u5907\u4e0d\u652f\u6301NFC\u529f\u80fd!", (int)3000);
            return false;
        }
        if (!this.mNfcAdapter.isEnabled()) {
            ToastUtils.show((Context)context, (String)"\u8bf7\u5230\u7cfb\u7edf\u8bbe\u7f6e\u4e2d\u6253\u5f00NFC\u529f\u80fd!", (int)3000);
            return false;
        }
        return true;
    }

    public void onResumeNFC(Activity activity) {
        if (this.mNfcAdapter != null && this.mPendingIntent != null) {
            this.mNfcAdapter.enableForegroundDispatch(activity, this.mPendingIntent, null, (String[][])null);
        }
    }

    public void onPauseNFC(Activity activity) {
        if (this.mNfcAdapter != null) {
            this.mNfcAdapter.disableForegroundDispatch(activity);
        }
    }

    public String dealNFCTag(Intent intent) {
        String action = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)action)) {
            return "\u83b7\u53d6\u6807\u7b7e\u4fe1\u606f\u5931\u8d25!";
        }
        Tag tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (tag == null) {
            return "\u83b7\u53d6\u6807\u7b7e\u5bf9\u8c61\u4e3a\u7a7a!";
        }
        String nfcMsg = "";
        if (action.equals("android.nfc.action.NDEF_DISCOVERED")) {
            Ndef ndef = Ndef.get((Tag)tag);
            nfcMsg = this.fireNdefEvent(ndef);
        } else if (action.equals("android.nfc.action.TECH_DISCOVERED")) {
            for (String tagTech : tag.getTechList()) {
                LogUtil.d((String)tagTech);
                if (tagTech.equals(NdefFormatable.class.getName())) {
                    nfcMsg = this.fireTagEvent(tag);
                    continue;
                }
                if (!tagTech.equals(Ndef.class.getName())) continue;
                Ndef ndef = Ndef.get((Tag)tag);
                nfcMsg = this.fireNdefEvent(ndef);
            }
        }
        if (action.equals("android.nfc.action.TAG_DISCOVERED")) {
            nfcMsg = this.fireTagEvent(tag);
        }
        if (this.onNFCListener != null) {
            this.onNFCListener.onNFCReceived(nfcMsg);
        }
        return nfcMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fireNdefEvent(Ndef ndef) {
        if (ndef != null) {
            try {
                ndef.connect();
                byte[] bytes = ndef.getTag().getId();
                String id = NFCHelper.bytesToHexString(bytes);
                LogUtil.d((String)id);
                NdefMessage ndefMessage = ndef.getNdefMessage();
                if (ndefMessage != null) {
                    String nfc;
                    NdefRecord[] ndefRecords = ndefMessage.getRecords();
                    String textRecord = "";
                    for (NdefRecord ndefRecord : ndefRecords) {
                        textRecord = NFCHelper.parseTextRecord(ndefRecord);
                    }
                    HashMap<String, String> jsonObject = new HashMap<String, String>();
                    jsonObject.put("id", id);
                    jsonObject.put("type", ndef.getType());
                    jsonObject.put("maxsize", ndef.getMaxSize() + " bytes");
                    jsonObject.put("textRecord", textRecord);
                    Gson gson = new Gson();
                    String string = nfc = gson.toJson(jsonObject);
                    return string;
                }
            }
            catch (FormatException | IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ndef.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public String fireTagEvent(Tag tag) {
        if (tag != null) {
            byte[] bytes = tag.getId();
            String id = NFCHelper.bytesToHexString(bytes);
            LogUtil.d((String)id);
            String[] techList = tag.getTechList();
            ArrayList<String> techTypes = new ArrayList<String>();
            for (String tech : techList) {
                techTypes.add(tech);
            }
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("id", id);
            jsonObject.put("techTypes", techTypes);
            Gson gson = new Gson();
            String nfc = gson.toJson(jsonObject);
            return nfc;
        }
        return "";
    }

    private static String readNfcTag(Intent intent) {
        if ("android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction())) {
            Parcelable[] rawMsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
            NdefMessage[] msgs = null;
            int contentSize = 0;
            if (rawMsgs != null) {
                msgs = new NdefMessage[rawMsgs.length];
                for (int i = 0; i < rawMsgs.length; ++i) {
                    msgs[i] = (NdefMessage)rawMsgs[i];
                    contentSize += msgs[i].toByteArray().length;
                }
            }
            try {
                if (msgs != null) {
                    NdefRecord record = msgs[0].getRecords()[0];
                    String textRecord = NFCHelper.parseTextRecord(record);
                    return textRecord + "\n\ntext\n" + contentSize + " bytes";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String parseTextRecord(NdefRecord ndefRecord) {
        if (ndefRecord.getTnf() != 1) {
            return null;
        }
        if (!Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
            return null;
        }
        try {
            byte[] payload = ndefRecord.getPayload();
            String textEncoding = (payload[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
            int languageCodeLength = payload[0] & 0x3F;
            String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
            String textRecord = new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
            return textRecord;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static String bytesToHexString(byte[] bytes) {
        String HEX = "0123456789ABCDEF";
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append("0123456789ABCDEF".charAt(bytes[i] >> 4 & 0xF));
            sb.append("0123456789ABCDEF".charAt(bytes[i] & 0xF));
        }
        return sb.toString();
    }

    public static String byteArrayToString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src != null && src.length > 0) {
            for (int i = 0; i < src.length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            return stringBuilder.toString().toUpperCase();
        }
        return null;
    }

    public void setOnNFCListener(OnNFCListener onNFCListener) {
        this.onNFCListener = onNFCListener;
    }

    public static interface OnNFCListener {
        public void onNFCReceived(String var1);
    }

    private static class NFCHelperHolder {
        private static final NFCHelper INSTANCE = new NFCHelper();

        private NFCHelperHolder() {
        }
    }
}

