/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.mes.nfc.controller;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.supcon.common.view.base.controller.BaseDataController;
import com.supcon.common.view.util.ToastUtils;
import com.supcon.mes.nfc.util.Byte2StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NFCController
extends BaseDataController {
    private static final String TAG = "NFC_TAG";
    private NfcAdapter mNfcAdapter;
    private PendingIntent mPendingIntent;
    private OnNFCListener onNFCListener;

    public NFCController(Context context) {
        super(context);
    }

    public void onInit() {
        super.onInit();
        this.setup(this.context);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void initListener() {
        super.initListener();
    }

    public void initData() {
        super.initData();
    }

    public void setup(Context context) {
        if (!this.checkNFC(context)) {
            return;
        }
        if (this.mPendingIntent == null) {
            this.mPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)new Intent(context, context.getClass()), (int)0);
        }
    }

    public boolean checkNFC(Context context) {
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        if (this.mNfcAdapter == null) {
            ToastUtils.show((Context)context, (String)"\u8bbe\u5907\u4e0d\u652f\u6301NFC\u529f\u80fd!", (int)3000);
            return false;
        }
        if (!this.mNfcAdapter.isEnabled()) {
            ToastUtils.show((Context)context, (String)"\u8bf7\u5230\u7cfb\u7edf\u8bbe\u7f6e\u4e2d\u6253\u5f00NFC\u529f\u80fd!", (int)3000);
            return false;
        }
        return true;
    }

    public void onResumeNFC(Activity activity) {
        if (this.mNfcAdapter != null && this.mPendingIntent != null) {
            this.mNfcAdapter.enableForegroundDispatch(activity, this.mPendingIntent, null, (String[][])null);
        }
    }

    public void onPauseNFC(Activity activity) {
        if (this.mNfcAdapter != null) {
            this.mNfcAdapter.disableForegroundDispatch(activity);
        }
    }

    public String dealNFCTag(Intent intent) {
        String action = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)action)) {
            return "\u83b7\u53d6\u6807\u7b7e\u4fe1\u606f\u5931\u8d25!";
        }
        Tag tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (tag == null) {
            return "\u83b7\u53d6\u6807\u7b7e\u5bf9\u8c61\u4e3a\u7a7a!";
        }
        String nfcMsg = "";
        if (action.equals("android.nfc.action.NDEF_DISCOVERED")) {
            Ndef ndef = Ndef.get((Tag)tag);
            nfcMsg = this.fireNdefEvent(ndef);
        } else if (action.equals("android.nfc.action.TECH_DISCOVERED")) {
            for (String tagTech : tag.getTechList()) {
                Log.d((String)TAG, (String)tagTech);
                if (tagTech.equals(NdefFormatable.class.getName())) {
                    nfcMsg = this.fireTagEvent(tag);
                    continue;
                }
                if (!tagTech.equals(Ndef.class.getName())) continue;
                Ndef ndef = Ndef.get((Tag)tag);
                nfcMsg = this.fireNdefEvent(ndef);
            }
        }
        if (action.equals("android.nfc.action.TAG_DISCOVERED")) {
            nfcMsg = this.fireTagEvent(tag);
        }
        if (this.onNFCListener != null) {
            this.onNFCListener.onNFCReceived(nfcMsg);
        }
        return nfcMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fireNdefEvent(Ndef ndef) {
        if (ndef != null) {
            try {
                ndef.connect();
                byte[] bytes = ndef.getTag().getId();
                String id = Byte2StringUtil.bytesToHexString(bytes);
                Log.d((String)TAG, (String)id);
                NdefMessage ndefMessage = ndef.getNdefMessage();
                if (ndefMessage != null) {
                    String nfc;
                    NdefRecord[] ndefRecords = ndefMessage.getRecords();
                    String textRecord = "";
                    for (NdefRecord ndefRecord : ndefRecords) {
                        textRecord = NFCController.parseTextRecord(ndefRecord);
                    }
                    HashMap<String, String> jsonObject = new HashMap<String, String>();
                    jsonObject.put("id", id);
                    jsonObject.put("type", ndef.getType());
                    jsonObject.put("maxsize", ndef.getMaxSize() + " bytes");
                    jsonObject.put("textRecord", textRecord);
                    Gson gson = new Gson();
                    String string = nfc = gson.toJson(jsonObject);
                    return string;
                }
            }
            catch (FormatException | IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ndef.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public String fireTagEvent(Tag tag) {
        if (tag != null) {
            byte[] bytes = tag.getId();
            String id = Byte2StringUtil.bytesToHexString(bytes);
            Log.d((String)TAG, (String)id);
            String[] techList = tag.getTechList();
            ArrayList<String> techTypes = new ArrayList<String>();
            for (String tech : techList) {
                techTypes.add(tech);
            }
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("id", id);
            jsonObject.put("techTypes", techTypes);
            Gson gson = new Gson();
            String nfc = gson.toJson(jsonObject);
            return nfc;
        }
        return "";
    }

    private static String parseTextRecord(NdefRecord ndefRecord) {
        if (ndefRecord.getTnf() != 1) {
            return null;
        }
        if (!Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
            return null;
        }
        try {
            byte[] payload = ndefRecord.getPayload();
            String textEncoding = (payload[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
            int languageCodeLength = payload[0] & 0x3F;
            String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
            String textRecord = new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
            return textRecord;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void setOnNFCListener(OnNFCListener onNFCListener) {
        this.onNFCListener = onNFCListener;
    }

    public static interface OnNFCListener {
        public void onNFCReceived(String var1);
    }
}

