package com.supcon.mes.nfc.util;

public class Byte2StringUtil {
    /**
     * 字节数组转为字符串信息
     * @param bytes
     * @author zhangwenshuai1
     * 2018/6/19
     *
     */
    public static String bytesToHexString(byte[] bytes) {
        final String HEX = "0123456789ABCDEF";
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
//        for (int i = bytes.length - 1; i >= 0; i--) {
        for (int i = 0; i < bytes.length; i++) {
            // 取出这个字节的高4位，然后与0x0f与运算，得到一个0-15之间的数据，通过HEX.charAt(0-15)即为16进制数
            sb.append(HEX.charAt((bytes[i] >> 4) & 0x0f));
            // 取出这个字节的低位，与0x0f与运算，得到一个0-15之间的数据，通过HEX.charAt(0-15)即为16进制数
            sb.append(HEX.charAt(bytes[i] & 0x0f));
        }

        return sb.toString();
    }

    public static String byteArrayToString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src != null && src.length > 0) {
            for(int i = 0; i < src.length; ++i) {
                int v = src[i] & 255;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }

                stringBuilder.append(hv);
            }

            return stringBuilder.toString().toUpperCase();
        } else {
            return null;
        }
    }
}
