/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.picker.framework;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.supcon.common.view.util.ConvertUtils;
import com.supcon.common.view.view.picker.framework.BasicPopup;

public abstract class ConfirmPopup<V extends View>
extends BasicPopup<View> {
    protected boolean topLineVisible = true;
    protected int topLineColor = -13388315;
    protected int topLineHeightPixels = 1;
    protected int topBackgroundColor = -1;
    protected int topHeight = 40;
    protected int topPadding = 15;
    protected int contentLeftAndRightPadding = 0;
    protected int contentTopAndBottomPadding = 0;
    protected boolean cancelVisible = true;
    protected CharSequence cancelText = "";
    protected CharSequence submitText = "";
    protected CharSequence titleText = "";
    protected int cancelTextColor = -13388315;
    protected int submitTextColor = -13388315;
    protected int titleTextColor = -16777216;
    protected int pressedTextColor = -16611122;
    protected int cancelTextSize = 0;
    protected int submitTextSize = 0;
    protected int titleTextSize = 0;
    protected int backgroundColor = -1;
    protected TextView cancelButton;
    protected TextView submitButton;
    protected TextView swapButton;
    protected View titleView;
    protected View headerView;
    protected View centerView;
    protected View footerView;

    public ConfirmPopup(Context activity) {
        super(activity);
        this.cancelText = activity.getString(0x1040000);
        this.submitText = activity.getString(17039370);
    }

    public void setTopLineColor(@ColorInt int topLineColor) {
        this.topLineColor = topLineColor;
    }

    public void setTopLineHeight(int topLineHeightPixels) {
        this.topLineHeightPixels = topLineHeightPixels;
    }

    public void setTopBackgroundColor(@ColorInt int topBackgroundColor) {
        this.topBackgroundColor = topBackgroundColor;
    }

    public void setTopHeight(@IntRange(from=10L, to=80L) int topHeight) {
        this.topHeight = topHeight;
    }

    public void setTopPadding(int topPadding) {
        this.topPadding = topPadding;
    }

    public void setTopLineVisible(boolean topLineVisible) {
        this.topLineVisible = topLineVisible;
    }

    public void setContentPadding(int leftAndRight, int topAndBottom) {
        this.contentLeftAndRightPadding = leftAndRight;
        this.contentTopAndBottomPadding = topAndBottom;
    }

    public void setCancelVisible(boolean cancelVisible) {
        if (null != this.cancelButton) {
            this.cancelButton.setVisibility(cancelVisible ? 0 : 8);
        } else {
            this.cancelVisible = cancelVisible;
        }
    }

    public void setCancelText(CharSequence cancelText) {
        if (null != this.cancelButton) {
            this.cancelButton.setText(cancelText);
        } else {
            this.cancelText = cancelText;
        }
    }

    public void setCancelText(@StringRes int textRes) {
        this.setCancelText(this.activity.getString(textRes));
    }

    public void setSubmitText(CharSequence submitText) {
        if (null != this.submitButton) {
            this.submitButton.setText(submitText);
        } else {
            this.submitText = submitText;
        }
    }

    public void setSubmitText(@StringRes int textRes) {
        this.setSubmitText(this.activity.getString(textRes));
    }

    public void setTitleText(CharSequence titleText) {
        if (this.titleView != null && this.titleView instanceof TextView) {
            ((TextView)this.titleView).setText(titleText);
        } else {
            this.titleText = titleText;
        }
    }

    public void setTitleText(@StringRes int textRes) {
        this.setTitleText(this.activity.getString(textRes));
    }

    public void setCancelTextColor(@ColorInt int cancelTextColor) {
        if (null != this.cancelButton) {
            this.cancelButton.setTextColor(cancelTextColor);
        } else {
            this.cancelTextColor = cancelTextColor;
        }
    }

    public void setSubmitTextColor(@ColorInt int submitTextColor) {
        if (null != this.submitButton) {
            this.submitButton.setTextColor(submitTextColor);
        } else {
            this.submitTextColor = submitTextColor;
        }
    }

    public void setTitleTextColor(@ColorInt int titleTextColor) {
        if (null != this.titleView && this.titleView instanceof TextView) {
            ((TextView)this.titleView).setTextColor(titleTextColor);
        } else {
            this.titleTextColor = titleTextColor;
        }
    }

    public void setPressedTextColor(int pressedTextColor) {
        this.pressedTextColor = pressedTextColor;
    }

    public void setCancelTextSize(@IntRange(from=10L, to=40L) int cancelTextSize) {
        this.cancelTextSize = cancelTextSize;
    }

    public void setSubmitTextSize(@IntRange(from=10L, to=40L) int submitTextSize) {
        this.submitTextSize = submitTextSize;
    }

    public void setTitleTextSize(@IntRange(from=10L, to=40L) int titleTextSize) {
        this.titleTextSize = titleTextSize;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTitleView(View titleView) {
        this.titleView = titleView;
    }

    public View getTitleView() {
        if (null == this.titleView) {
            throw new NullPointerException("please call show at first");
        }
        return this.titleView;
    }

    public TextView getCancelButton() {
        if (null == this.cancelButton) {
            throw new NullPointerException("please call show at first");
        }
        return this.cancelButton;
    }

    public TextView getSubmitButton() {
        if (null == this.submitButton) {
            throw new NullPointerException("please call show at first");
        }
        return this.submitButton;
    }

    public void setHeaderView(View headerView) {
        this.headerView = headerView;
    }

    public void setFooterView(View footerView) {
        this.footerView = footerView;
    }

    @Override
    protected final View makeContentView() {
        LinearLayout rootLayout = new LinearLayout(this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setBackgroundColor(this.backgroundColor);
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(10, 0, 10, 0);
        rootLayout.setClipToPadding(false);
        View headerView = this.makeHeaderView();
        if (headerView != null) {
            rootLayout.addView(headerView);
        }
        if (this.topLineVisible) {
            View lineView = new View(this.activity);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, this.topLineHeightPixels);
            lp.topMargin = ConvertUtils.toPx(this.activity, 0.0f);
            lp.bottomMargin = ConvertUtils.toPx(this.activity, 5.0f);
            lineView.setLayoutParams((ViewGroup.LayoutParams)lp);
            lineView.setBackgroundColor(this.topLineColor);
            rootLayout.addView(lineView);
        }
        if (this.centerView == null) {
            this.centerView = this.makeCenterView();
        }
        int lr = 0;
        int tb = 0;
        if (this.contentLeftAndRightPadding > 0) {
            lr = ConvertUtils.toPx(this.activity, this.contentLeftAndRightPadding);
        }
        if (this.contentTopAndBottomPadding > 0) {
            tb = ConvertUtils.toPx(this.activity, this.contentTopAndBottomPadding);
        }
        this.centerView.setPadding(lr, tb, lr, tb);
        ViewGroup vg = (ViewGroup)this.centerView.getParent();
        if (vg != null) {
            vg.removeView(this.centerView);
        }
        rootLayout.addView(this.centerView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        View footerView = this.makeFooterView();
        if (footerView != null) {
            rootLayout.addView(footerView);
        }
        return rootLayout;
    }

    @Nullable
    protected View makeHeaderView() {
        if (null != this.headerView) {
            return this.headerView;
        }
        RelativeLayout topButtonLayout = new RelativeLayout(this.activity);
        int height = ConvertUtils.toPx(this.activity, this.topHeight);
        int p = ConvertUtils.toPx(this.activity, 10.0f);
        topButtonLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
        topButtonLayout.setBackgroundColor(this.topBackgroundColor);
        topButtonLayout.setGravity(16);
        this.cancelButton = new TextView(this.activity);
        this.cancelButton.setVisibility(this.cancelVisible ? 0 : 8);
        RelativeLayout.LayoutParams cancelParams = new RelativeLayout.LayoutParams(-2, -1);
        cancelParams.addRule(9, -1);
        cancelParams.addRule(15, -1);
        this.cancelButton.setLayoutParams((ViewGroup.LayoutParams)cancelParams);
        this.cancelButton.setBackgroundColor(0);
        this.cancelButton.setGravity(17);
        int padding = ConvertUtils.toPx(this.activity, this.topPadding);
        this.cancelButton.setPadding(padding, 0, padding, 0);
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            this.cancelButton.setText(this.cancelText);
        }
        this.cancelButton.setTextColor(ConvertUtils.toColorStateList(this.cancelTextColor, this.pressedTextColor));
        if (this.cancelTextSize != 0) {
            this.cancelButton.setTextSize((float)this.cancelTextSize);
        }
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onCancel();
            }
        });
        topButtonLayout.addView((View)this.cancelButton);
        if (null == this.titleView) {
            int margin;
            TextView textView = new TextView(this.activity);
            RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
            titleParams.leftMargin = margin = ConvertUtils.toPx(this.activity, this.topPadding);
            titleParams.rightMargin = margin;
            titleParams.addRule(14, -1);
            titleParams.addRule(15, -1);
            textView.setLayoutParams((ViewGroup.LayoutParams)titleParams);
            textView.setGravity(17);
            if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
                textView.setText(this.titleText);
            }
            textView.setTextColor(this.titleTextColor);
            if (this.titleTextSize != 0) {
                textView.setTextSize((float)this.titleTextSize);
            }
            this.titleView = textView;
        }
        topButtonLayout.addView(this.titleView);
        this.submitButton = new TextView(this.activity);
        RelativeLayout.LayoutParams submitParams = new RelativeLayout.LayoutParams(-2, -1);
        submitParams.addRule(11, -1);
        submitParams.addRule(15, -1);
        this.submitButton.setLayoutParams((ViewGroup.LayoutParams)submitParams);
        this.submitButton.setBackgroundColor(0);
        this.submitButton.setGravity(17);
        this.submitButton.setPadding(padding, 0, padding, 0);
        if (!TextUtils.isEmpty((CharSequence)this.submitText)) {
            this.submitButton.setText(this.submitText);
        }
        this.submitButton.setTextColor(ConvertUtils.toColorStateList(this.submitTextColor, this.pressedTextColor));
        if (this.submitTextSize != 0) {
            this.submitButton.setTextSize((float)this.submitTextSize);
        }
        this.submitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onSubmit();
            }
        });
        topButtonLayout.addView((View)this.submitButton);
        return topButtonLayout;
    }

    @NonNull
    protected abstract V makeCenterView();

    @Nullable
    protected View makeFooterView() {
        if (null != this.footerView) {
            return this.footerView;
        }
        return null;
    }

    protected void onSubmit() {
    }

    protected void onCancel() {
    }
}

