/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.supcon.common.view.R;

public class IOSLoaderView
extends ImageView {
    private float rotateDegrees;
    private int frameTime;
    private boolean needToUpdateView;
    private Runnable updateViewRunnable;

    public IOSLoaderView(Context context) {
        this(context, null);
    }

    public IOSLoaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setImageResource(R.drawable.ic_ios_progress);
        this.frameTime = 83;
        this.updateViewRunnable = new Runnable(){

            @Override
            public void run() {
                IOSLoaderView.this.rotateDegrees = IOSLoaderView.this.rotateDegrees + 30.0f;
                IOSLoaderView.this.rotateDegrees = IOSLoaderView.this.rotateDegrees < 360.0f ? IOSLoaderView.this.rotateDegrees : IOSLoaderView.this.rotateDegrees - 360.0f;
                IOSLoaderView.this.invalidate();
                if (IOSLoaderView.this.needToUpdateView) {
                    IOSLoaderView.this.postDelayed(this, IOSLoaderView.this.frameTime);
                }
            }
        };
    }

    protected void onDraw(Canvas canvas) {
        canvas.rotate(this.rotateDegrees, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.needToUpdateView = true;
        this.post(this.updateViewRunnable);
    }

    protected void onDetachedFromWindow() {
        this.needToUpdateView = false;
        super.onDetachedFromWindow();
    }
}

