/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.ptr;

import android.os.Build;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.supcon.common.view.ptr.PtrFrameLayout;
import com.supcon.common.view.ptr.PtrHandler;
import com.supcon.common.view.util.ViewUtils;

public abstract class PtrDefaultHandler
implements PtrHandler {
    public static boolean canChildScrollUp(View view) {
        View header;
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                AbsListView absListView = (AbsListView)view;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return view.getScrollY() > 0;
        }
        if (view != null && view instanceof ListView && ((ListView)view).getHeaderViewsCount() > 0 && (header = ((ListView)view).getChildAt(0)) != null) {
            return ViewUtils.getViewLocationScreenY(header) < ViewUtils.getViewLocationScreenY(view) || view.canScrollVertically(-1);
        }
        return view.canScrollVertically(-1);
    }

    public static boolean checkContentCanBePulledDown(PtrFrameLayout frame, View content, View header) {
        return !PtrDefaultHandler.canChildScrollUp(content);
    }

    @Override
    public boolean checkCanDoRefresh(PtrFrameLayout frame, View content, View header) {
        return PtrDefaultHandler.checkContentCanBePulledDown(frame, content, header);
    }
}

