/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.LinearLayout;
import com.app.annotation.Presenter;
import com.supcon.common.com_router.router.PresenterRouter;
import com.supcon.common.com_router.widget.IWidget;
import com.supcon.common.view.App;
import com.supcon.common.view.base.presenter.BasePresenter;
import com.supcon.common.view.contract.IBaseView;
import com.supcon.common.view.listener.OnChildViewClickListener;
import com.supcon.common.view.util.InstanceUtil;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.ViewBinder;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class BaseWidgetLayout
extends LinearLayout
implements IWidget,
IBaseView {
    protected OnChildViewClickListener onChildViewClickListener;
    protected View rootView;
    protected ViewStub tempView;
    protected Context context;
    protected Disposable timer;
    private long interval;
    private Activity mActivity;
    protected PresenterRouter presenterRouter;
    private List<BasePresenter> mPresenters = new ArrayList<BasePresenter>();

    public void initPresenter() {
        Annotation[] annotations;
        this.presenterRouter = new PresenterRouter();
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            Class[] presenters;
            if (!(annotation instanceof Presenter)) continue;
            for (Class presenter : presenters = ((Presenter)annotation).value()) {
                if (!(this instanceof IBaseView)) continue;
                BasePresenter basePresenter = (BasePresenter)InstanceUtil.getInstance(presenter);
                this.presenterRouter.register((Object)basePresenter);
                this.addPresenter(basePresenter);
                LogUtil.d("Widget presenter " + presenter.getName() + " added!");
            }
        }
    }

    private void addPresenter(BasePresenter basePresenter) {
        basePresenter.attachView(this);
        this.mPresenters.add(basePresenter);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for (BasePresenter presenter : this.mPresenters) {
            if (presenter == null) continue;
            presenter.detachView();
        }
    }

    public void setOnChildViewClickListener(OnChildViewClickListener onChildViewClickListener) {
        this.onChildViewClickListener = onChildViewClickListener;
    }

    protected void onChildViewClick(View childView, int action, Object obj) {
        if (this.onChildViewClickListener != null) {
            this.onChildViewClickListener.onChildViewClick(childView, action, obj);
        }
    }

    protected void onChildViewClick(View childView, int action) {
        this.onChildViewClick(childView, action, null);
    }

    public BaseWidgetLayout(Context context) {
        super(context);
        this.initPresenter();
        this.mActivity = (Activity)context;
    }

    public BaseWidgetLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPresenter();
    }

    protected abstract int layoutId();

    public void bind(ViewStub view) {
        this.bindViewStup(view);
    }

    public void doRefresh(long intervel) {
        this.interval = intervel;
        if (intervel == 0L) {
            this.refresh();
        } else {
            this.refresh();
            this.startTimer();
        }
    }

    protected void bindViewStup(ViewStub viewStub) {
        this.tempView = viewStub;
        this.tempView.setLayoutResource(this.layoutId());
        this.init(viewStub.getContext(), null);
    }

    protected void init(Context context, AttributeSet attrs) {
        this.context = context;
        if (this.layoutId() != 0) {
            this.rootView = this.tempView != null ? this.tempView.inflate() : LayoutInflater.from((Context)context).inflate(this.layoutId(), (ViewGroup)this, true);
            if (this.rootView != null) {
                // empty if block
            }
            if (attrs != null) {
                this.initAttributeSet(attrs);
            }
        } else {
            throw new IllegalArgumentException("layoutId cannot return 0!");
        }
        this.bindView();
        this.initView();
        this.initListener();
        this.initData();
    }

    protected void initAttributeSet(AttributeSet attrs) {
    }

    private void bindView() {
        ViewBinder.bindTag(this, this.rootView);
    }

    protected void initView() {
    }

    protected void initListener() {
    }

    protected void initData() {
    }

    protected void refresh() {
    }

    protected void startTimer() {
        this.timer = Flowable.timer((long)this.interval, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> {
            if (this.isFrontActivity()) {
                this.refresh();
            }
            this.startTimer();
        });
    }

    public void stopRefresh() {
        if (this.timer != null) {
            this.timer.dispose();
            this.timer = null;
        }
    }

    protected boolean isCover(View view) {
        if (view == null) {
            return false;
        }
        boolean cover = false;
        Rect rect = new Rect();
        cover = view.getGlobalVisibleRect(rect);
        if (cover && rect.width() >= view.getMeasuredWidth() && rect.height() >= view.getMeasuredHeight()) {
            return !cover;
        }
        return true;
    }

    private boolean isFrontActivity() {
        return this.mActivity.equals(App.getAppContext().getCurActivity());
    }
}

