/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.controller;

import android.content.Context;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.supcon.common.view.base.adapter.IListAdapter;
import com.supcon.common.view.base.controller.RefreshListController;

public class RefreshAbsListController<TModel>
extends RefreshListController<AbsListView, TModel> {
    protected AbsListView.OnScrollListener onScrollListener;
    protected IListAdapter<TModel> emptyAdapter;

    public RefreshAbsListController(Context context, View view, IListAdapter<TModel> listAdapter) {
        super(context, view, listAdapter);
    }

    @Override
    public void initData() {
        this.setAbsListViewAdapter(this.listAdapter);
        super.initData();
    }

    private void setAbsListViewAdapter(IListAdapter adapter) {
        if (this.getContentView() instanceof ExpandableListView) {
            ((ExpandableListView)this.getContentView()).setAdapter((ExpandableListAdapter)adapter);
        } else {
            ((AbsListView)this.getContentView()).setAdapter((ListAdapter)adapter);
        }
    }

    @Override
    public void initListener() {
        super.initListener();
        ((AbsListView)this.getContentView()).setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (RefreshAbsListController.this.onScrollListener != null) {
                    RefreshAbsListController.this.onScrollListener.onScrollStateChanged(view, scrollState);
                }
                if (scrollState == 0 && view.getLastVisiblePosition() == view.getCount() - 1 && RefreshAbsListController.this.isLoadMoreEnable) {
                    RefreshAbsListController.this.refreshMore();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (RefreshAbsListController.this.onScrollListener != null) {
                    RefreshAbsListController.this.onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                }
            }
        });
    }

    @Override
    public void setLoadMoreEnable(boolean enableLoadMore) {
        super.setLoadMoreEnable(enableLoadMore);
        if (enableLoadMore) {
            if (this.getContentView() instanceof ListView) {
                ((ListView)this.getContentView()).addFooterView(this.mDefaultMoreViewController.getMoreView());
            }
        } else if (this.getContentView() instanceof ListView) {
            ((ListView)this.getContentView()).removeFooterView(this.mDefaultMoreViewController.getMoreView());
        }
    }

    @Override
    public void setEmpterAdapter(IListAdapter emptyAdapter) {
        this.emptyAdapter = emptyAdapter;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    @Override
    protected void switchAdapter() {
        if (this.emptyAdapter != null && (this.listAdapter.getList() == null || this.listAdapter.getList().size() == 0)) {
            ((AbsListView)this.getContentView()).setAdapter((ListAdapter)this.emptyAdapter);
        } else if (((AbsListView)this.getContentView()).getAdapter() != this.listAdapter) {
            ((AbsListView)this.getContentView()).setAdapter((ListAdapter)this.listAdapter);
        }
    }
}

