package com.supcon.common.view.ptr;

import android.view.View;

public interface PtrHandler {

    /**
     * Check can do refresh or not. For example the content is empty or the first child is in view.
     * @param frame PtrFrameLayout
     * @param content View
     * @param header View
     * @return  boolean
     * {@link PtrDefaultHandler#checkContentCanBePulledDown}
     */
    public boolean checkCanDoRefresh(final PtrFrameLayout frame, final View content, final View header);

    /**
     * When refresh begin
     *
     * @param frame PtrFrameLayout
     */
    public void onRefreshBegin(final PtrFrameLayout frame);
}