/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import android.view.View;
import java.lang.reflect.Field;

public class ViewUtils {
    public static int getViewLocationScreenX(View view) {
        return ViewUtils.getViewLocationScreenXY(view, 0);
    }

    public static int getViewLocationScreenY(View view) {
        return ViewUtils.getViewLocationScreenXY(view, 1);
    }

    public static int getViewLocationWindowX(View view) {
        return ViewUtils.getViewLocationWindowXY(view, 0);
    }

    public static int getViewLocationWindowY(View view) {
        return ViewUtils.getViewLocationWindowXY(view, 1);
    }

    private static int getViewLocationScreenXY(View view, int index) {
        int[] xy = new int[2];
        view.getLocationOnScreen(xy);
        return xy[index];
    }

    private static int getViewLocationWindowXY(View view, int index) {
        int[] xy = new int[2];
        view.getLocationInWindow(xy);
        return xy[index];
    }

    public static int getId(Context paramContext, String className, String resName) {
        try {
            Class<?> localClass = Class.forName(paramContext.getPackageName() + ".R$" + className);
            Field localField = localClass.getField(resName);
            int i = Integer.parseInt(localField.get(localField.getName()).toString());
            return i;
        }
        catch (Exception localException) {
            Log.e((String)"getIdByReflection error", (String)localException.getMessage());
            return 0;
        }
    }

    public static Activity getActivityFromView(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static Context getContextFromView(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

