/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.supcon.common.view.view.picker.framework.ConfirmPopup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiplePicker
extends ConfirmPopup<ScrollView> {
    private List<String> items = new ArrayList<String>();
    private LinearLayout layout;
    private OnItemPickListener onItemPickListener;

    public MultiplePicker(Activity activity, String[] items) {
        this(activity, Arrays.asList(items));
    }

    public MultiplePicker(Activity activity, List<String> items) {
        super((Context)activity);
        this.items = items;
    }

    public void setOnItemPickListener(OnItemPickListener onItemPickListener) {
        this.onItemPickListener = onItemPickListener;
    }

    @Override
    @NonNull
    protected ScrollView makeCenterView() {
        ScrollView scrollView = new ScrollView(this.activity);
        this.layout = new LinearLayout(this.activity);
        this.layout.setOrientation(1);
        for (String item : this.items) {
            LinearLayout line = new LinearLayout(this.activity);
            line.setOrientation(0);
            line.setGravity(17);
            TextView textView = new TextView(this.activity);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -2, 1.0f);
            lp.gravity = 17;
            textView.setLayoutParams((ViewGroup.LayoutParams)lp);
            textView.setText((CharSequence)item);
            textView.setGravity(17);
            line.addView((View)textView);
            CheckBox checkBox = new CheckBox(this.activity);
            checkBox.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 0.4f));
            line.addView((View)checkBox);
            this.layout.addView((View)line);
        }
        scrollView.addView((View)this.layout);
        return scrollView;
    }

    @Override
    protected void onSubmit() {
        if (this.onItemPickListener == null) {
            return;
        }
        ArrayList<String> checked = new ArrayList<String>();
        int count = this.layout.getChildCount();
        for (int i = 0; i < count; ++i) {
            LinearLayout line = (LinearLayout)this.layout.getChildAt(i);
            CheckBox checkBox = (CheckBox)line.getChildAt(1);
            if (!checkBox.isChecked()) continue;
            TextView textView = (TextView)line.getChildAt(0);
            checked.add(textView.getText().toString());
        }
        this.onItemPickListener.onItemPicked(checked.size(), checked);
    }

    public static interface OnItemPickListener {
        public void onItemPicked(int var1, List<String> var2);
    }
}

