/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader.base;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.supcon.common.view.R;
import com.supcon.common.view.util.DisplayUtil;
import com.supcon.common.view.view.MyPopupWindow;
import com.supcon.common.view.view.loader.CircularLoaderView;
import com.supcon.common.view.view.loader.base.BaseLoader;

public class DefautLoader
extends BaseLoader {
    public DefautLoader(Context context, View rootView) {
        super(context, rootView);
    }

    @Override
    protected void initPop() {
        super.initPop();
        if (this.mloader != null) {
            View contentView = this.mloader.getContentView();
            CircularLoaderView circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
            circularButtonLoaderView.setDoneColor(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeBlue));
            circularButtonLoaderView.setInitialHeight(DisplayUtil.dip2px(80.0f, this.context));
            circularButtonLoaderView.setSpinningBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeOrange));
            this.mloader.update();
        }
    }

    @Override
    protected int contentViewId() {
        return R.layout.ly_loader_lol;
    }

    @Override
    public void showLoader(String msg) {
        if (this.mloader != null && this.mloader.isShowing()) {
            this.showMsgOnly(msg);
        } else {
            this.showDefaultLoader(msg);
        }
    }

    private void showDefaultLoader(String msg) {
        try {
            CircularLoaderView circularButtonLoaderView = null;
            View contentView = null;
            if (this.mloader == null) {
                contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.ly_loader_lol, null);
                circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
                circularButtonLoaderView.setDoneColor(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeBlue));
                circularButtonLoaderView.setInitialHeight(DisplayUtil.dip2px(80.0f, this.context));
                circularButtonLoaderView.setSpinningBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeOrange));
                this.mloader = new MyPopupWindow(DisplayUtil.dip2px(120.0f, this.context), DisplayUtil.dip2px(120.0f, this.context));
                this.mloader.setBackgroundDrawable(this.context.getResources().getDrawable(R.drawable.bg_loader_stroke));
                this.mloader.setFocusable(true);
                this.mloader.setCancelOutSide(false);
                this.mloader.setContentView(contentView);
                this.mloader.update();
            } else {
                contentView = this.mloader.getContentView();
                circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
            }
            circularButtonLoaderView.revertAnimation();
            circularButtonLoaderView.startAnimation();
            ((TextView)contentView.findViewById(R.id.common_msg)).setText((CharSequence)(msg != null ? msg : "\u6b63\u5728\u5904\u7406..."));
            this.mloader.showAtLocation(this.getRootView(), 17, 0, 0);
            this.backgroundAlpha(0.6f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeLoader() {
        super.closeLoader();
    }

    @Override
    public void showResultMsg(String msg, boolean isSuccess) {
        if (isSuccess) {
            this.doneSuccess(msg);
        } else {
            this.doneFailed(msg);
        }
    }

    @Override
    public void showMsg(String msg) {
        if (this.mloader != null && this.mloader.isShowing()) {
            this.showMsgOnly(msg);
        } else {
            this.showDefaultLoader(msg);
        }
    }

    private void showMsgOnly(String msg) {
        try {
            View contentView = this.mloader.getContentView();
            ((TextView)contentView.findViewById(R.id.common_msg)).setText((CharSequence)(TextUtils.isEmpty((CharSequence)msg) ? "\u6b63\u5728\u5904\u7406..." : msg));
            this.mloader.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doneSuccess(String msg) {
        if (this.mloader != null && this.mloader.isShowing()) {
            View contentView = this.mloader.getContentView();
            boolean hasMsg = !TextUtils.isEmpty((CharSequence)msg);
            CircularLoaderView circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
            ((TextView)contentView.findViewById(R.id.common_msg)).setText((CharSequence)(hasMsg ? msg : "\u64cd\u4f5c\u6210\u529f"));
            circularButtonLoaderView.doneLoadingAnimation(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeBlue), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ic_success2));
        }
    }

    private void doneFailed(String msg) {
        if (this.mloader != null && this.mloader.isShowing()) {
            View contentView = this.mloader.getContentView();
            boolean hasMsg = !TextUtils.isEmpty((CharSequence)msg);
            CircularLoaderView circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
            TextView textView = (TextView)contentView.findViewById(R.id.common_msg);
            textView.setVisibility(0);
            textView.setText((CharSequence)msg);
            circularButtonLoaderView.doneLoadingAnimation(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeOrange), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ic_fail));
        }
    }

    private void closeDefaultLoader(String msg, boolean isSuccess) {
        if (this.mloader != null && this.mloader.isShowing()) {
            View contentView = this.mloader.getContentView();
            boolean hasMsg = !TextUtils.isEmpty((CharSequence)msg);
            CircularLoaderView circularButtonLoaderView = (CircularLoaderView)contentView.findViewById(R.id.common_loader);
            if (!isSuccess) {
                TextView textView = (TextView)contentView.findViewById(R.id.common_msg);
                textView.setVisibility(0);
                textView.setText((CharSequence)msg);
                circularButtonLoaderView.doneLoadingAnimation(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeOrange), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ic_fail));
            } else {
                ((TextView)contentView.findViewById(R.id.common_msg)).setText((CharSequence)(hasMsg ? msg : "\u64cd\u4f5c\u6210\u529f"));
                circularButtonLoaderView.doneLoadingAnimation(ContextCompat.getColor((Context)this.context, (int)R.color.bapThemeBlue), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ic_success2));
            }
        }
    }
}

