/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.ptr.indicator;

import com.supcon.common.view.ptr.indicator.PtrIndicator;

public class PtrTensionIndicator
extends PtrIndicator {
    private float DRAG_RATE = 0.5f;
    private float mDownY;
    private float mDownPos;
    private float mOneHeight = 0.0f;
    private float mCurrentDragPercent;
    private int mReleasePos;
    private float mReleasePercent = -1.0f;

    @Override
    public void onPressDown(float x, float y) {
        super.onPressDown(x, y);
        this.mDownY = y;
        this.mDownPos = this.getCurrentPosY();
    }

    @Override
    public void onRelease() {
        super.onRelease();
        this.mReleasePos = this.getCurrentPosY();
        this.mReleasePercent = this.mCurrentDragPercent;
    }

    @Override
    public void onUIRefreshComplete() {
        this.mReleasePos = this.getCurrentPosY();
        this.mReleasePercent = this.getOverDragPercent();
    }

    @Override
    public void setHeaderHeight(int height) {
        super.setHeaderHeight(height);
        this.mOneHeight = (float)height * 4.0f / 5.0f;
    }

    @Override
    protected void processOnMove(float currentX, float currentY, float offsetX, float offsetY) {
        if (currentY < this.mDownY) {
            super.processOnMove(currentX, currentY, offsetX, offsetY);
            return;
        }
        float scrollTop = (currentY - this.mDownY) * this.DRAG_RATE + this.mDownPos;
        float currentDragPercent = scrollTop / this.mOneHeight;
        if (currentDragPercent < 0.0f) {
            this.setOffset(offsetX, 0.0f);
            return;
        }
        this.mCurrentDragPercent = currentDragPercent;
        float boundedDragPercent = Math.min(1.0f, Math.abs(currentDragPercent));
        float extraOS = scrollTop - this.mOneHeight;
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, this.mOneHeight * 2.0f) / this.mOneHeight);
        float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
        float extraMove = this.mOneHeight * tensionPercent / 2.0f;
        int targetY = (int)(this.mOneHeight * boundedDragPercent + extraMove);
        int change = targetY - this.getCurrentPosY();
        this.setOffset(currentX, change);
    }

    private float offsetToTarget(float scrollTop) {
        float currentDragPercent;
        this.mCurrentDragPercent = currentDragPercent = scrollTop / this.mOneHeight;
        float boundedDragPercent = Math.min(1.0f, Math.abs(currentDragPercent));
        float extraOS = scrollTop - this.mOneHeight;
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, this.mOneHeight * 2.0f) / this.mOneHeight);
        float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
        float extraMove = this.mOneHeight * tensionPercent / 2.0f;
        int targetY = (int)(this.mOneHeight * boundedDragPercent + extraMove);
        return 0.0f;
    }

    @Override
    public int getOffsetToKeepHeaderWhileLoading() {
        return this.getOffsetToRefresh();
    }

    @Override
    public int getOffsetToRefresh() {
        return (int)this.mOneHeight;
    }

    public float getOverDragPercent() {
        if (this.isUnderTouch()) {
            return this.mCurrentDragPercent;
        }
        if (this.mReleasePercent <= 0.0f) {
            return 1.0f * (float)this.getCurrentPosY() / (float)this.getOffsetToKeepHeaderWhileLoading();
        }
        return this.mReleasePercent * (float)this.getCurrentPosY() / (float)this.mReleasePos;
    }
}

