/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.supcon.common.view.listener.OnChildViewClickListener;
import com.supcon.common.view.util.ViewBinder;

public abstract class BaseFrameLayout
extends FrameLayout {
    protected OnChildViewClickListener onChildViewClickListener;
    protected Context context;
    protected View rootView;

    public void setOnChildViewClickListener(OnChildViewClickListener onChildViewClickListener) {
        this.onChildViewClickListener = onChildViewClickListener;
    }

    protected void onChildViewClick(View childView, int action, Object obj) {
        if (this.onChildViewClickListener != null) {
            this.onChildViewClickListener.onChildViewClick(childView, action, obj);
        }
    }

    protected void onChildViewClick(View childView, int action) {
        this.onChildViewClick(childView, action, null);
    }

    public BaseFrameLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public BaseFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    protected abstract int layoutId();

    protected void init(Context context, AttributeSet attrs) {
        this.context = context;
        if (this.layoutId() != 0) {
            this.rootView = LayoutInflater.from((Context)context).inflate(this.layoutId(), (ViewGroup)this, true);
            if (this.rootView != null) {
                // empty if block
            }
            if (attrs != null) {
                this.initAttributeSet(attrs);
            }
        } else {
            throw new IllegalArgumentException("layoutId cannot return 0!");
        }
        this.bindView();
        this.initView();
        this.initListener();
        this.initData();
    }

    protected void initAttributeSet(AttributeSet attrs) {
    }

    private void bindView() {
        ViewBinder.bindTag((Object)this, this.rootView);
    }

    protected void initView() {
    }

    protected void initListener() {
    }

    protected void initData() {
    }
}

