/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.controller;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.supcon.common.view.R;
import com.supcon.common.view.base.adapter.IListAdapter;
import com.supcon.common.view.base.controller.IRefreshListController;
import com.supcon.common.view.base.controller.RefreshController;
import com.supcon.common.view.base.view.BaseRelativeLayout;
import com.supcon.common.view.listener.OnRefreshPageListener;
import java.util.List;

public abstract class RefreshListController<TView extends View, TModel>
extends RefreshController<TView>
implements IRefreshListController<TModel> {
    protected int pageIndex = 0;
    protected boolean isRefresh = false;
    protected boolean isMoreData = true;
    protected boolean isLoadMoreEnable = false;
    protected IListAdapter<TModel> listAdapter;
    protected OnRefreshPageListener onRefreshPageListener;
    protected DefaultMoreViewController mDefaultMoreViewController;
    protected static final int MoreStatus_None = 1000;
    protected static final int MoreStatus_Load = 1001;
    protected static final int MoreStatus_Error = 1002;
    protected static final int MoreStatus_Complete = 1003;
    protected static final int MoreStatus_NoMoreData = 1004;
    protected static final int MoreStatus_NoMoreData2 = 1005;

    public RefreshListController(Context context, View layout2, IListAdapter<TModel> listAdapter) {
        this(context, layout2);
        this.listAdapter = listAdapter;
    }

    @Override
    public IListAdapter<TModel> getListAdapter() {
        return this.listAdapter;
    }

    @Override
    public void setOnRefreshPageListener(OnRefreshPageListener onRefreshPageListener) {
        this.onRefreshPageListener = onRefreshPageListener;
        this.setLoadMoreEnable(true);
    }

    @Override
    public void setLoadMoreEnable(boolean loadMoreEnable) {
        this.isLoadMoreEnable = loadMoreEnable;
        if (this.isLoadMoreEnable && this.mDefaultMoreViewController == null) {
            this.mDefaultMoreViewController = new DefaultMoreViewController(this.mContext);
            this.mDefaultMoreViewController.getMoreView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!RefreshListController.this.isRefresh && RefreshListController.this.mDefaultMoreViewController.status != 1004) {
                        RefreshListController.this.refreshMore();
                    }
                }
            });
        }
    }

    @Override
    public void setDefaultMoreViewController(DefaultMoreViewController defaultMoreViewController) {
        this.mDefaultMoreViewController = defaultMoreViewController;
        defaultMoreViewController.getMoreView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!RefreshListController.this.isRefresh && RefreshListController.this.mDefaultMoreViewController.status != 1004) {
                    RefreshListController.this.refreshMore();
                }
            }
        });
    }

    @Override
    public void setListAdapter(IListAdapter listAdapter) {
        this.listAdapter = listAdapter;
    }

    public RefreshListController(Context context, View layout2) {
        super(context, layout2);
    }

    @Override
    public void onRefreshBegin() {
        if (!this.isRefresh) {
            this.pageIndex = 0;
            if (this.isLoadMoreEnable) {
                this.isMoreData = true;
                this.setMoreStatus(1000);
                this.onRefresh(this.pageIndex + 1);
            } else if (this.onRefreshPageListener != null) {
                this.onRefreshPageListener.onRefresh(this.pageIndex + 1);
            } else {
                super.onRefreshBegin();
            }
        }
    }

    protected boolean isMoreData() {
        return this.isMoreData;
    }

    protected void refreshMore() {
        if (!this.isRefresh && this.isLoadMoreEnable && this.isMoreData()) {
            this.setPullDownRefreshEnabled(false);
            this.setMoreStatus(1001);
            this.onRefresh(this.pageIndex + 1);
        }
    }

    private void onRefresh(int pageIndex) {
        if (this.onRefreshPageListener != null) {
            this.onRefreshPageListener.onRefresh(pageIndex);
            this.isRefresh = true;
        }
    }

    protected void setMoreStatus(int status) {
        this.setPullDownRefreshEnabled(true);
        if (1004 == status) {
            this.isMoreData = false;
        }
        this.isRefresh = false;
        try {
            if (this.mDefaultMoreViewController != null) {
                this.mDefaultMoreViewController.setStatus(status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mDefaultMoreViewController.setStatus(0);
        }
    }

    @Override
    public void refreshComplete() {
        super.refreshComplete();
        this.isRefresh = false;
    }

    private boolean isEmptyList(List<?> list) {
        return list == null || list.size() == 0;
    }

    @Override
    public void refreshComplete(List list) {
        ++this.pageIndex;
        if (this.listAdapter != null) {
            if (this.pageIndex == 1 || !this.isLoadMoreEnable) {
                this.listAdapter.setList(list);
                this.switchAdapter();
                this.refreshComplete();
                this.listAdapter.notifyDataSetChanged();
            } else if (this.isEmptyList(list)) {
                this.setMoreStatus(1004);
            } else {
                this.setMoreStatus(1003);
                this.listAdapter.addList(list);
                this.listAdapter.notifyDataSetChanged();
            }
        }
    }

    @Override
    public void refreshError(Throwable ex) {
        if (this.pageIndex == 0) {
            this.refreshComplete();
        } else {
            this.setMoreStatus(1002);
        }
    }

    public boolean isLoadMoreEnable() {
        return this.isLoadMoreEnable;
    }

    protected void switchAdapter() {
    }

    public static class DefaultMoreViewController
    extends BaseRelativeLayout {
        private ProgressBar progressBar;
        private TextView textView;
        private int status;

        public DefaultMoreViewController(Context context) {
            super(context);
        }

        public DefaultMoreViewController(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        @Override
        protected void initView() {
            super.initView();
            this.rootView.setVisibility(8);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progressBar);
            this.textView = (TextView)this.rootView.findViewById(R.id.textView);
        }

        public View getMoreView() {
            return this;
        }

        public void setStatus(int status) {
            this.rootView.setVisibility(0);
            this.status = status;
            this.textView.setVisibility(0);
            this.progressBar.setVisibility(4);
            switch (status) {
                case 1001: {
                    this.progressBar.setVisibility(0);
                    this.textView.setText((CharSequence)"\u52a0\u8f7d\u4e2d...");
                    break;
                }
                case 1002: {
                    this.textView.setText((CharSequence)"\u52a0\u8f7d\u66f4\u591a");
                    break;
                }
                case 1004: {
                    this.textView.setText((CharSequence)"\u6ca1\u6709\u66f4\u591a\u4e86");
                    break;
                }
                case 1005: {
                    this.textView.setVisibility(8);
                    break;
                }
                case 1003: {
                    this.textView.setVisibility(8);
                    break;
                }
                default: {
                    this.textView.setVisibility(4);
                }
            }
        }

        @Override
        protected int layoutId() {
            return R.layout.item_loadmore;
        }
    }
}

