/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import com.supcon.common.view.App;
import com.supcon.common.view.R;
import com.supcon.common.view.base.IData;
import com.supcon.common.view.util.KeyboardUtil;
import com.supcon.common.view.util.LoaderErrorMsgHelper;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.StatusBarUtils;
import com.supcon.common.view.util.ViewBinder;
import com.supcon.common.view.view.loader.base.LoaderController;
import com.supcon.common.view.view.loader.base.OnLoaderFinishListener;
import com.supcon.common.view.view.swipeback.SwipeBackController;
import java.util.Map;

public abstract class BaseFragmentActivity
extends FragmentActivity
implements IData,
SwipeBackController.Delegate {
    protected Context context;
    protected FragmentManager fragmentManager;
    protected View rootView;
    protected LoaderController loaderController;
    protected SwipeBackController swipeBackController;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        this.rootView = LayoutInflater.from((Context)this).inflate(this.getLayoutID(), null);
        this.setContentView(this.rootView);
        this.fragmentManager = this.getSupportFragmentManager();
        this.onInit();
        this.initView();
        this.initListener();
        this.initData();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected abstract int getLayoutID();

    protected void onInit() {
        this.loaderController = new LoaderController((Context)this, this.rootView);
        ViewBinder.bindTag((Activity)this);
    }

    protected void initView() {
        this.initSwipeBackController();
    }

    protected void initData() {
    }

    protected void initListener() {
        ViewBinder.bindCustomView(this, this.rootView);
        ViewBinder.bindListener(this, this.rootView);
    }

    public View getRootView() {
        return this.rootView;
    }

    public void back() {
        this.finish();
    }

    public void onBackPressed() {
        this.back();
    }

    public void onDestroy() {
        super.onDestroy();
        this.loaderController.onDestroy();
    }

    protected void finalize() throws Throwable {
        LogUtil.d("finalize() " + this.toString());
        super.finalize();
    }

    protected void showErrorMsg(String msg) {
        LoaderErrorMsgHelper.showErrorMsg(this.loaderController, msg);
    }

    public void onLoading(String msg) {
        this.loaderController.showLoader(msg);
    }

    public void onLoading() {
        this.onLoading("");
    }

    public void onLoadSuccess(String msg) {
        this.onLoadSuccessAndExit(msg, null);
    }

    public void onLoadSuccessAndExit(String msg, OnLoaderFinishListener listener) {
        this.loaderController.showMsgAndclose(msg, true, 500L, listener);
    }

    public void onLoadFailed(String msg) {
        this.showErrorMsg(msg);
    }

    public void closeLoader() {
        this.loaderController.closeLoader();
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean checkBeforeSubmit(Map<String, Object> map) {
        return this.doSave(map);
    }

    @Override
    public boolean doSave(Map<String, Object> map) {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void setStatusBarColor(int colorResId) {
        StatusBarUtils.setWindowStatusBarColor((Activity)this, colorResId);
    }

    @Override
    public boolean isSwipeBackEnable() {
        return this.swipeBackController != null && this.swipeBackController.isSwipeBackEnable();
    }

    public void setSwipeBackEnable(boolean swipeBackEnable) {
        if (this.swipeBackController != null) {
            this.swipeBackController.setSwipeBackEnable(swipeBackEnable);
        }
    }

    private void initSwipeBackController() {
        this.swipeBackController = new SwipeBackController((Activity)this, this);
        this.swipeBackController.setSwipeBackEnable(true);
        this.swipeBackController.setIsOnlyTrackingLeftEdge(true);
        this.swipeBackController.setIsWeChatStyle(true);
        this.swipeBackController.setShadowResId(R.drawable.bg_sbl_shadow);
        this.swipeBackController.setIsNeedShowShadow(true);
        this.swipeBackController.setIsShadowAlphaGradient(true);
        this.swipeBackController.setSwipeBackThreshold(0.3f);
        this.swipeBackController.setIsNavigationBarOverlap(false);
    }

    @Override
    public boolean isSupportSwipeBack() {
        return true;
    }

    @Override
    public void onSwipeBackSlide(float slideOffset) {
    }

    @Override
    public void onSwipeBackCancel() {
    }

    @Override
    public void onSwipeBackStop(int errorCode) {
        if (errorCode == 2) {
            this.onBackPressed();
        }
    }

    @Override
    public void onSwipeBackExecuted() {
        KeyboardUtil.closeKeyboard((Activity)this);
        this.back();
        this.executeBackwardAnim();
    }

    public void executeBackwardAnim() {
        this.overridePendingTransition(0, 0);
    }

    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = res.getConfiguration();
        config.fontScale = (double)App.fontSizeScale > 0.5 ? App.fontSizeScale : 1.0f;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return res;
    }
}

