package com.supcon.common.view.base.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Message;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.supcon.common.BaseConstant;
import com.supcon.common.view.R;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.StatusBarUtils;
import com.supcon.common.view.util.ToastUtils;
import com.supcon.common.view.util.UrlUtil;
import com.supcon.common.view.view.js.BridgeHandler;
import com.supcon.common.view.view.js.BridgeWebView;
import com.supcon.common.view.view.js.CallBackFunction;
import com.supcon.common.view.view.js.DefaultHandler;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;

import static com.supcon.common.view.App.fontSizeScale;

/**
 * Created by wangshizhan on 2018/12/20
 * Email:wangshizhan@supcom.com
 */
public abstract class BaseWebViewActivity extends BaseActivity {

    public static final int QUERY_TYPE_QUERY = 0;
    public static final int QUERY_TYPE_PENDING = QUERY_TYPE_QUERY+1;

    protected BridgeWebView webView;
    protected ProgressBar pbProgress;
    protected TextView titleText;
    protected ImageButton leftBtn;
    protected ImageButton rightBtn;

    private String url;
    private String cookie;
    private Map<String, String> headers;
    private String authorization;
    private boolean isDialog = false;
    private boolean hasRefresh = false;
    protected boolean isList = false;
    protected int queryType = QUERY_TYPE_PENDING;
    protected long pendingId;
    private boolean isPendingRefresh = false;
    protected boolean needTitle = false;

    private static final int RESULT_CODE = 0;
    private ValueCallback<Uri> uploadMessage;
    private ValueCallback<Uri[]> uploadMessageAboveL;
    private CallBackFunction mFileCallBackFunction;

    @Override
    protected void onInit() {
        super.onInit();
        url             = getIntent().getStringExtra(BaseConstant.WEB_URL);
        cookie          = getIntent().getStringExtra(BaseConstant.WEB_COOKIE);
        headers         = (Map<String, String>) getIntent().getSerializableExtra(BaseConstant.WEB_HEADER);
        authorization   = getIntent().getStringExtra(BaseConstant.WEB_AUTHORIZATION);
        hasRefresh      = getIntent().getBooleanExtra(BaseConstant.WEB_HAS_REFRESH, false);
        isList          = getIntent().getBooleanExtra(BaseConstant.WEB_IS_LIST, false);

        if(TextUtils.isEmpty(url)){
            throw new IllegalArgumentException("传参错误！");
        }
        LogUtil.i("Url:"+url+"\nCookie:"+cookie+"\nAuthorization:"+authorization);

        if(headers!=null){
            LogUtil.i(" Headers:"+headers.values());
        }

        pendingId = UrlUtil.parseIdFormUrl(url, "pendingId");

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void initView() {
        super.initView();

        webView = rootView.findViewWithTag("webview");
        pbProgress = rootView.findViewWithTag("pb_progress");
        titleText = rootView.findViewWithTag("titleText");
        leftBtn = rootView.findViewWithTag("leftBtn");
        rightBtn = rootView.findViewWithTag("rightBtn");

        if(rightBtn!=null && hasRefresh) {
            rightBtn.setImageResource(R.drawable.sl_top_refresh);
            rightBtn.setVisibility(View.VISIBLE);
        }
        StatusBarUtils.setWindowStatusBarColor(this, R.color.webThemeColor);
        if(leftBtn!=null){
            ((ViewGroup)leftBtn.getParent()).setBackgroundResource(R.color.webThemeColor);
        }
        toggleTitle(false);
        needTitle = false;
        initWebView();
    }

    @Override
    protected void initListener() {
        super.initListener();

        webView.registerHandler("close", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("close" + data);
                back();

            }

        });

        webView.registerHandler("webGoBack", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("webGoBack" + data);
//                function.onCallBack("接收到js调用close方法");
                if(webView.canGoBack()){
                    webView.goBack();
                }
                else{
                    back();
                }
            }

        });

        webView.registerHandler("showSubmit", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("showSubmit" + data);
//                function.onCallBack("接收到js调用showSubmit方法");
            }

        });

        webView.registerHandler("setTitle", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("setTitle" + data);
//                function.onCallBack("接收到js调用setTitle方法");
                if(!TextUtils.isEmpty(data)){

                    try {
                        JSONObject jsonObject = new JSONObject(data);

                        setTitle(jsonObject.getString("param"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                }
            }

        });

        webView.registerHandler("onloadStart", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("onloadStart" + data);
//                function.onCallBack("接收到js调用onloadStart方法");

            }

        });

        webView.registerHandler("onloadEnd", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("onloadEnd" + data);
//                function.onCallBack("接收到js调用onloadEnd方法");

            }

        });

        webView.registerHandler("pendingRefresh", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("pendingRefresh" + data);
//                function.onCallBack("接收到js调用pendingRefresh方法");
//                isPendingRefresh = true;
            }

        });


        webView.registerHandler("supmobileReload", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("supmobileReload" + data);
//                function.onCallBack("接收到js调用onReload方法");
                ToastUtils.show(context, getString(R.string.common_login_valid));

            }

        });

        webView.registerHandler("openDialog", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("openDialog" + data);
//                function.onCallBack("接收到js调用openDialog方法");
                setIsDialog(true);
            }

        });

        webView.registerHandler("closeDialog", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("closeDialog" + data);
//                function.onCallBack("接收到js调用closeDialog方法");
                setIsDialog(false);
            }

        });

        webView.registerHandler("showTitle", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("showTitle" + data);
//                function.onCallBack("接收到js调用openDialog方法");
                toggleTitle(true);
            }

        });

        webView.registerHandler("hideTitle", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("hideTitle" + data);
//                function.onCallBack("接收到js调用closeDialog方法");
                toggleTitle(false);
            }

        });

        webView.registerHandler("supconUpload", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("supconUpload" + data);

                pickFile();
                mFileCallBackFunction = function;
//                function.onCallBack("接收到js调用supconUpload方法");
            }

        });

        webView.registerHandler("mobileReload", new BridgeHandler() {

            @Override
            public void handler(String data, CallBackFunction function) {

                LogUtil.i("mobileReload" + data);

                onReload();
            }

        });




        if(leftBtn!=null) {
            leftBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
        }

        if(rightBtn!=null){
            rightBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onReload();
                }
            });
        }


    }

    public void onPageStart(WebView view, String url, Bitmap favicon){

    }

    public void onPageCommitVisible(WebView view, String url){

    }

    public void onPageFinished(WebView view, String url){

    }


    protected void onReload() {
        webView.reload();
    }

    public void setPendingRefresh(boolean pendingRefresh) {
        isPendingRefresh = pendingRefresh;
    }

    @Override
    protected void initData() {
        super.initData();


        loadUrl();
    }

    private void loadUrl() {
        Map<String, String> header = new HashMap<>();

        if(!TextUtils.isEmpty(cookie)){
            header.put("Cookie", cookie);
        }

        if(!TextUtils.isEmpty(authorization)){
            header.put("Authorization", authorization);
        }

        if(headers!=null){
            header.putAll(headers);
        }


        webView.loadUrl(url, header);
    }




    private void initWebView() {

        if(webView == null){
            throw new IllegalArgumentException("BridgeWebView is null!");
        }
        webView.setDefaultHandler(new DefaultHandler());

//        webView.getSettings().setAppCacheEnabled(true);//启用localstorage本地存储api
//        webView.getSettings().setLightTouchEnabled(true);//启用选中功能
//        webView.getSettings().setDomStorageEnabled(true);//启用dom存储(关键就是这句)，貌似网上twitter显示有问题也是这个属性没有设置的原因
//        webView.getSettings().setDatabaseEnabled(true);//启用html5数据库功能
//        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);

        WebSettings settings = webView.getSettings();
        settings.setAppCacheEnabled(false);
//        settings.setJavaScriptEnabled(true);
        settings.setAllowFileAccess(true);
        settings.setDatabaseEnabled(true);
        String dir = this.getApplicationContext().getDir("database", Context.MODE_PRIVATE).getPath();
        settings.setDatabasePath(dir);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setLightTouchEnabled(true);
        settings.setAllowUniversalAccessFromFileURLs(true);

        setWebChromeClient(new DefaultWebChromeClient());
    }

    protected void setWebChromeClient(WebChromeClient webChromeClient){
        webView.setWebChromeClient(webChromeClient);
    }


    protected void callJSFunction(final String jsFunctionName, String data){
        webView.callHandler(jsFunctionName, data, new CallBackFunction() {
            @Override
            public void onCallBack(String data) {
                LogUtil.i("function:"+jsFunctionName+" onCallBack data = " + data);
            }
        });
    }


    protected void registerHandler(String name, BridgeHandler handler){
        webView.registerHandler(name, handler);
    }

    protected void sendMessageToJs(String message){
        webView.send(message, new CallBackFunction() {
            @Override
            public void onCallBack(String data) {
                LogUtil.i("sendMessageToJs onCallBack data = " + data);
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();


    }



    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    @Override
    public void onBackPressed() {

        if(isDialog){
            return;
        }

        if(webView.canGoBack()){
            webView.goBack();
        }
        else{
            super.onBackPressed();
        }

    }

//    @Override
//    public boolean onKeyDown(int keyCode, KeyEvent event) {
//
//        if(keyCode == KeyEvent.KEYCODE_BACK && !hasHeader){
//            if(webView.canGoBack()){
//                webView.goBack();
//                return false;
//            }
//
//            if(webView.isInEditMode()){
//                LogUtil.d("isInEditMode");
//            }
//        }
//
//        return super.onKeyDown(keyCode, event);
//    }

//    private long parsePendingId(String url){
//        Uri uri = Uri.parse(url);
//        Object parameter = uri.getQueryParameter("pendingId");
//        if(parameter!=null){
//
//            return Long.parseLong(parameter.toString());
//        }
//
//        return 0;
//    }

    public void setTitle(String title){
        if(titleText!=null){
            titleText.setText(title);
        }
    }

    public void setIsDialog(boolean isDialog){
        this.isDialog = isDialog;

        if(titleText == null || !needTitle){
            return;
        }

        if(isDialog){
            ((ViewGroup)titleText.getParent()).setVisibility(View.GONE);
        }
        else{
            ((ViewGroup)titleText.getParent()).setVisibility(View.VISIBLE);
        }
    }

    public void toggleTitle(boolean open){

        if(titleText == null && !needTitle){
            return;
        }
        if(!open){
            ((ViewGroup)titleText.getParent()).setVisibility(View.GONE);
        }
        else{
            ((ViewGroup)titleText.getParent()).setVisibility(View.VISIBLE);
        }
    }

    @SuppressLint("CheckResult")
    public void loginValid(){
        if(isList) {
//            webView.reload();
            loadUrl();
        }
        else {
            ToastUtils.show(context, getString(R.string.common_login_valid));
            Flowable.timer(500, TimeUnit.MILLISECONDS)
                    .subscribe(new Consumer<Long>() {
                        @Override
                        public void accept(Long aLong) throws Exception {
                            back();
                        }
                    });
        }

    }

    @SuppressLint("CheckResult")
    public void unauthorized(){
//        ToastUtils.show(context, "登陆已失效，请重新登陆");
        ToastUtils.show(context, getResources().getString(R.string.common_login_valid));
        Flowable.timer(500, TimeUnit.MILLISECONDS)
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(Long aLong) throws Exception {
                        back();
                    }
                });
    }

    public void serverError(){
//        ToastUtils.show(context, "服务器错误");
        LogUtil.e(getString(R.string.common_server_error));
//        needTitle = true;
//        toggleTitle(true);
    }

    public void sendRefreshEvent(){
        LogUtil.d("sendRefreshEvent");
        onReload();
    }

    public  void next(String url){
        if(this.url!=null && this.url.equals(url)){
            onReload();
        }
        else {
            goNext(url);
        }
    }

    public  boolean checkUrl(String inUrl){
        long newPendingId = UrlUtil.parseIdFormUrl(inUrl, "pendingId");
        long deploymentId  = UrlUtil.parseIdFormUrl(inUrl, "deploymentId");

        return  pendingId!=0 && newPendingId !=0 && pendingId == newPendingId || deploymentId !=0 && newPendingId==0&&isPendingRefresh;
    }

    public  boolean isSave(String inUrl){
        long newPendingId = UrlUtil.parseIdFormUrl(inUrl, "pendingId");
        long deploymentId  = UrlUtil.parseIdFormUrl(inUrl, "deploymentId");

        return  pendingId!=0 && newPendingId !=0 && pendingId == newPendingId || deploymentId ==0 && newPendingId!=0;
    }

    protected void goNext(String url){

    }

    //图片
    private final static int FILE_CHOOSER_RESULT_CODE = 128;
    //拍照
    private final static int FILE_CAMERA_RESULT_CODE = 129;
    //拍照图片路径
    private String cameraFielPath;


    public void pickPicture(){

        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        startActivityForResult(intent, RESULT_CODE);

    }


    public void pickFile() {
        Intent chooserIntent = new Intent(Intent.ACTION_GET_CONTENT);
        chooserIntent.setType("*/*");
        startActivityForResult(chooserIntent, RESULT_CODE);
    }

    private void openImageChooserActivity() {

        new MaterialDialog.Builder(this)
                .items(R.array.photo)
                .positiveText(getString(R.string.common_cancel))
                .onPositive(new MaterialDialog.SingleButtonCallback() {
                    @Override
                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        if (uploadMessageAboveL != null) {
                            uploadMessageAboveL.onReceiveValue(null);
                            uploadMessageAboveL = null;
                        }
                        if (uploadMessage != null) {
                            uploadMessage.onReceiveValue(null);
                            uploadMessage = null;
                        }
                        dialog.dismiss();
                    }
                })
                .cancelable(false)
                .canceledOnTouchOutside(false)
                .itemsCallback(new MaterialDialog.ListCallback() {
                    @Override
                    public void onSelection(MaterialDialog dialog, View itemView, int position, CharSequence text) {
                        if (position == 0) {
                            takeCamera();
                        } else if (position == 1) {
                            takePhoto();
                        }
                    }
                }).show();
    }

    //选择图片
    private void takePhoto() {
        Intent i = new Intent(Intent.ACTION_GET_CONTENT);
        i.addCategory(Intent.CATEGORY_OPENABLE);
        i.setType("image/*");
        startActivityForResult(Intent.createChooser(i, "Image Chooser"), FILE_CHOOSER_RESULT_CODE);
    }

    //拍照
    private void takeCamera() {
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        File file = new File(Environment.getExternalStorageDirectory() + "/supcon/");
        if (!file.exists()) {
          file.mkdirs();
        }
        cameraFielPath = Environment.getExternalStorageDirectory() + "/supcon/upload_"+System.currentTimeMillis()+".jpg";
        File outputImage = new File(cameraFielPath);
        intent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(outputImage));
        startActivityForResult(intent, FILE_CAMERA_RESULT_CODE);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (null == uploadMessage && null == uploadMessageAboveL) return;
        if (resultCode != RESULT_OK) {//同上所说需要回调onReceiveValue方法防止下次无法响应js方法
            if (uploadMessageAboveL != null) {
                uploadMessageAboveL.onReceiveValue(null);
                uploadMessageAboveL = null;
            }
            if (uploadMessage != null) {
                uploadMessage.onReceiveValue(null);
                uploadMessage = null;
            }
            return;
        }
        Uri result = null;
        if (requestCode == FILE_CAMERA_RESULT_CODE) {
            if (null != data && null != data.getData()) {
                result = data.getData();
            }
            if (result == null && hasFile(cameraFielPath)) {
                result = Uri.fromFile(new File(cameraFielPath));
            }
            if (uploadMessageAboveL != null) {
                uploadMessageAboveL.onReceiveValue(new Uri[]{result});
                uploadMessageAboveL = null;
            } else if (uploadMessage != null) {
                uploadMessage.onReceiveValue(result);
                uploadMessage = null;
            }
        } else if (requestCode == FILE_CHOOSER_RESULT_CODE) {
            if (data != null) {
                result = data.getData();
            }
            if (uploadMessageAboveL != null) {
                onActivityResultAboveL(data);
            } else if (uploadMessage != null) {
                uploadMessage.onReceiveValue(result);
                uploadMessage = null;
            }
        }
    }

    /**
     * 判断文件是否存在
     */
    public static boolean hasFile(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                return false;
            }
        } catch (Exception e) {
            // TODO: handle exception
            return false;
        }
        return true;
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void onActivityResultAboveL(Intent intent) {
        Uri[] results = null;
        if (intent != null) {
            String dataString = intent.getDataString();
            ClipData clipData = intent.getClipData();
            if (clipData != null) {
                results = new Uri[clipData.getItemCount()];
                for (int i = 0; i < clipData.getItemCount(); i++) {
                    ClipData.Item item = clipData.getItemAt(i);
                    results[i] = item.getUri();
                }
            }
            if (dataString != null)
                results = new Uri[]{Uri.parse(dataString)};
        }
        uploadMessageAboveL.onReceiveValue(results);
        uploadMessageAboveL = null;
    }

    protected void uploadFile(File file, CallBackFunction callBackFunction){

    }

    protected void showDialog(String message, JsResult result){

    }

    public class DefaultWebChromeClient extends WebChromeClient{

        @SuppressWarnings("unused")
        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType, String capture) {
            this.openFileChooser(uploadMsg);
        }

        @SuppressWarnings("unused")
        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType) {
            this.openFileChooser(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {

            uploadMessage = uploadMsg;
            openImageChooserActivity();
        }

        @Override
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
            uploadMessageAboveL = filePathCallback;
            openImageChooserActivity();
            return true;
        }

        @Override
        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
//            LogUtil.d("onConsoleMessage");
            return super.onConsoleMessage(consoleMessage);
        }

        @Override
        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            LogUtil.d("onJsBeforeUnload");
            return super.onJsBeforeUnload(view, url, message, result);
        }

        @Override
        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            LogUtil.d("onJsPrompt");
            return super.onJsPrompt(view, url, message, defaultValue, result);
        }

        @Override
        public void onReceivedIcon(WebView view, Bitmap icon) {
//            LogUtil.d("onReceivedIcon");
            super.onReceivedIcon(view, icon);
        }

        @Override
        public void onGeolocationPermissionsHidePrompt() {
            LogUtil.d("onGeolocationPermissionsHidePrompt");
            super.onGeolocationPermissionsHidePrompt();
        }

        @Override
        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            LogUtil.d("onGeolocationPermissionsShowPrompt");
            super.onGeolocationPermissionsShowPrompt(origin, callback);
        }

        @Override
        public void onPermissionRequest(PermissionRequest request) {
            LogUtil.d("onPermissionRequest");
            super.onPermissionRequest(request);
        }

        @Override
        public void onPermissionRequestCanceled(PermissionRequest request) {
            LogUtil.d("onPermissionRequestCanceled");
            super.onPermissionRequestCanceled(request);
        }

        @Override
        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            LogUtil.d("onReceivedTouchIconUrl");
            super.onReceivedTouchIconUrl(view, url, precomposed);
        }

        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress == 100) {
                // 网页加载完成
                if(pbProgress!=null)
                    pbProgress.setVisibility(View.GONE);
            } else {
                // 加载中
                if(pbProgress!=null) {
                    pbProgress.setVisibility(View.VISIBLE);
                    pbProgress.setProgress(newProgress);
                }
            }
            super.onProgressChanged(view, newProgress);
        }

        @Override
        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            LogUtil.d("onCreateWindow");
            return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        @Override
        public void onHideCustomView() {
            super.onHideCustomView();
            LogUtil.d("onHideCustomView");
        }

        @Override
        public void onCloseWindow(WebView window) {
            super.onCloseWindow(window);
            LogUtil.d("onCloseWindow");
            back();
        }

        @Override
        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);

            if(!TextUtils.isEmpty(title) && title.length() > 10){
                return;
            }
            LogUtil.d("onReceivedTitle:"+title);
            setTitle(title);
        }

        @Override
        public void onShowCustomView(View view, CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            LogUtil.d("onShowCustomView");
        }

        @Override
        public void onRequestFocus(WebView view) {
            super.onRequestFocus(view);
            LogUtil.d("onRequestFocus");
        }

        @Override
        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {

            showDialog(message, result);
            return true;
//            return super.onJsAlert(view, url, message, result);
        }

        @Override
        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {

            showDialog(message, result);
            return true;
//                return super.onJsConfirm(view, url, message, result);
        }

    }


    /**
     * 更改应用内的系统字体大小  适配8.0以上版本
     *
     * @return
     */
    @Override
    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = res.getConfiguration();
        if (fontSizeScale > 0.5) {
            config.fontScale = fontSizeScale;
        } else {
            config.fontScale = 1;
        }
        res.updateConfiguration(config, res.getDisplayMetrics());
        return res;
    }
}
