/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader.base;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import com.supcon.common.view.R;
import com.supcon.common.view.view.MyPopupWindow;
import com.supcon.common.view.view.loader.base.ILoader;
import java.lang.ref.WeakReference;

public abstract class BaseLoader
implements ILoader {
    protected MyPopupWindow mloader;
    protected Context context;
    private WeakReference<View> rootView;

    public BaseLoader(Context context, View rootView) {
        this.init(context, rootView);
        this.initPop();
    }

    protected void initPop() {
        if (this.contentViewId() != 0) {
            View contentView = LayoutInflater.from((Context)this.context).inflate(this.contentViewId(), null);
            if (this.mloader == null) {
                this.mloader = new MyPopupWindow(contentView, -2, -2);
                this.mloader.setBackgroundDrawable(this.context.getResources().getDrawable(R.drawable.bg_loader));
                this.mloader.setFocusable(true);
                this.mloader.setCancelOutSide(false);
                this.mloader.update();
            }
        }
    }

    protected abstract int contentViewId();

    private void init(Context context, View rootView) {
        this.rootView = new WeakReference<View>(rootView);
        this.context = context;
    }

    protected View getRootView() {
        if (this.rootView != null && this.rootView.get() != null) {
            return (View)this.rootView.get();
        }
        return null;
    }

    protected void backgroundAlpha(float f) {
        WindowManager.LayoutParams lp = ((Activity)this.context).getWindow().getAttributes();
        lp.alpha = f;
        ((Activity)this.context).getWindow().setAttributes(lp);
    }

    @Override
    public void closeLoader() {
        if (this.mloader != null) {
            this.mloader.dismiss(true);
        }
        this.backgroundAlpha(1.0f);
    }
}

