/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.js;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.supcon.common.view.base.activity.BaseWebViewActivity;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.view.js.BaseBridgeWebViewClient;
import com.supcon.common.view.view.js.BridgeUtil;
import com.supcon.common.view.view.js.BridgeWebView;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class BridgeWebViewClientNew
extends BaseBridgeWebViewClient {
    private boolean isOpenPending = false;
    private BaseWebViewActivity mBaseWebViewActivity;

    public BridgeWebViewClientNew(BridgeWebView webView) {
        super(webView);
        if (this.mBaseWebViewActivity == null && webView.getContext() instanceof BaseWebViewActivity) {
            this.mBaseWebViewActivity = (BaseWebViewActivity)webView.getContext();
        }
    }

    @Override
    public void onLoadResource(WebView view, String url) {
        super.onLoadResource(view, url);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean dealUrl(WebView view, String url) {
        LogUtil.d("shouldOverrideUrlLoading url:" + url);
        WebView.HitTestResult hit = this.webView.getHitTestResult();
        int hitType = hit.getType();
        LogUtil.w("hitType:" + hitType);
        if (hitType == 0) {
            if (url.contains("/cas/login")) {
                this.mBaseWebViewActivity.loginValid();
                return true;
            }
            if (url.contains("open-pending")) {
                this.isOpenPending = true;
                return false;
            }
            if (this.isOpenPending) {
                this.newWeb(view.getContext(), url);
                return true;
            }
            this.newWeb(view.getContext(), url);
            return true;
        }
        if (hitType == 7) {
            this.mBaseWebViewActivity.back();
            return true;
        }
        if (hitType != 9) return false;
        this.mBaseWebViewActivity.loginValid();
        return true;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.mBaseWebViewActivity.onPageStart(view, url, favicon);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mBaseWebViewActivity.onPageFinished(view, url);
        BridgeUtil.webViewLoadLocalJs(view, "mobile.js");
    }

    @Override
    public void onPageCommitVisible(WebView view, String url) {
        super.onPageCommitVisible(view, url);
        this.mBaseWebViewActivity.onPageCommitVisible(view, url);
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        if (Build.VERSION.SDK_INT >= 21) {
            LogUtil.e("onReceivedHttpError1:" + errorResponse.getReasonPhrase());
            if ("Unauthorized".equals(errorResponse.getReasonPhrase())) {
                this.mBaseWebViewActivity.unauthorized();
                return;
            }
            if ("Internal Server Error".equals(errorResponse.getReasonPhrase())) {
                this.mBaseWebViewActivity.serverError();
                return;
            }
        }
        super.onReceivedHttpError(view, request, errorResponse);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        LogUtil.e("onReceivedHttpError2:" + errorCode);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        super.onScaleChanged(view, oldScale, newScale);
    }

    private void newWeb(Context context, String url) {
        this.mBaseWebViewActivity.next(url);
    }

    @SuppressLint(value={"CheckResult"})
    private void sendRefreshEventToParent(Context context) {
        Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                BridgeWebViewClientNew.this.mBaseWebViewActivity.sendRefreshEvent();
            }
        });
    }
}

