/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.js;

import android.graphics.Bitmap;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.view.js.BridgeUtil;
import com.supcon.common.view.view.js.BridgeWebView;
import com.supcon.common.view.view.js.Message;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public abstract class BaseBridgeWebViewClient
extends WebViewClient {
    protected BridgeWebView webView;

    public BaseBridgeWebViewClient(BridgeWebView webView) {
        this.webView = webView;
    }

    public void onLoadResource(WebView view, String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.contains(".action")) {
            if (!url.contains("clientType")) {
                url = url + "&clientType=android";
            }
            if (!url.contains("hideWebTitle")) {
                url = url + "&hideWebTitle=false";
            }
        }
        super.onLoadResource(view, url);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (url.startsWith("yy://return/")) {
            this.webView.handlerReturnData(url);
            return true;
        }
        if (url.startsWith("yy://")) {
            this.webView.flushMessageQueue();
            return true;
        }
        if (this.dealUrl(view, url)) {
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    protected abstract boolean dealUrl(WebView var1, String var2);

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 24) {
            String url = request.getUrl().toString();
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            if (url.startsWith("yy://return/")) {
                this.webView.handlerReturnData(url);
                return true;
            }
            if (url.startsWith("yy://")) {
                this.webView.flushMessageQueue();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, request);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            LogUtil.d("shouldOverrideUrlLoading url:" + request.getUrl());
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
    }

    public void onPageCommitVisible(WebView view, String url) {
        super.onPageCommitVisible(view, url);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        BridgeUtil.webViewLoadLocalJs(view, "WebViewJavascriptBridge.js");
        if (this.webView.getStartupMessage() != null) {
            for (Message m : this.webView.getStartupMessage()) {
                this.webView.dispatchMessage(m);
            }
            this.webView.setStartupMessage(null);
        }
    }

    protected void onLoadBridge() {
        BridgeUtil.webViewLoadLocalJs(this.webView, "WebViewJavascriptBridge.js");
    }
}

