/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.swipeback;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.view.View;
import com.supcon.common.view.util.KeyboardUtil;
import com.supcon.common.view.view.swipeback.SwipeBackLayout;

public class SwipeBackController {
    private Activity mActivity;
    private Delegate mDelegate;
    private SwipeBackLayout mSwipeBackLayout;

    public SwipeBackController(Activity activity, Delegate delegate) {
        this.mActivity = activity;
        this.mDelegate = delegate;
        this.initSwipeBack();
    }

    private void initSwipeBack() {
        if (this.mDelegate.isSupportSwipeBack()) {
            this.mSwipeBackLayout = new SwipeBackLayout((Context)this.mActivity);
            this.mSwipeBackLayout.attachToActivity(this.mActivity);
            this.mSwipeBackLayout.setPanelSlideListener(new SwipeBackLayout.PanelSlideListener(){

                @Override
                public void onPanelStop(int msg) {
                    SwipeBackController.this.mDelegate.onSwipeBackStop(msg);
                }

                @Override
                public void onPanelSlide(View panel, float slideOffset) {
                    if ((double)slideOffset < 0.03) {
                        KeyboardUtil.closeKeyboard(SwipeBackController.this.mActivity);
                    }
                    SwipeBackController.this.mDelegate.onSwipeBackSlide(slideOffset);
                }

                @Override
                public void onPanelOpened(View panel) {
                    SwipeBackController.this.mDelegate.onSwipeBackExecuted();
                }

                @Override
                public void onPanelClosed(View panel) {
                    SwipeBackController.this.mDelegate.onSwipeBackCancel();
                }
            });
        }
    }

    public SwipeBackController setSwipeBackEnable(boolean swipeBackEnable) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setSwipeBackEnable(swipeBackEnable);
        }
        return this;
    }

    public boolean isSwipeBackEnable() {
        return this.mSwipeBackLayout.isSwipeBackEnable();
    }

    public SwipeBackController setIsOnlyTrackingLeftEdge(boolean isOnlyTrackingLeftEdge) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsOnlyTrackingLeftEdge(isOnlyTrackingLeftEdge);
        }
        return this;
    }

    public SwipeBackController setIsWeChatStyle(boolean isWeChatStyle) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsWeChatStyle(isWeChatStyle);
        }
        return this;
    }

    public SwipeBackController setShadowResId(@DrawableRes int shadowResId) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setShadowResId(shadowResId);
        }
        return this;
    }

    public SwipeBackController setIsNeedShowShadow(boolean isNeedShowShadow) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsNeedShowShadow(isNeedShowShadow);
        }
        return this;
    }

    public SwipeBackController setIsShadowAlphaGradient(boolean isShadowAlphaGradient) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsShadowAlphaGradient(isShadowAlphaGradient);
        }
        return this;
    }

    public SwipeBackController setSwipeBackThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setSwipeBackThreshold(threshold);
        }
        return this;
    }

    public SwipeBackController setIsNavigationBarOverlap(boolean overlap) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsNavigationBarOverlap(overlap);
        }
        return this;
    }

    public boolean isSliding() {
        if (this.mSwipeBackLayout != null) {
            return this.mSwipeBackLayout.isSliding();
        }
        return false;
    }

    public static interface Delegate {
        public boolean isSupportSwipeBack();

        public void onSwipeBackSlide(float var1);

        public void onSwipeBackCancel();

        public void onSwipeBackStop(int var1);

        public void onSwipeBackExecuted();

        public boolean isSwipeBackEnable();
    }
}

