/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.loader;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.R;
import com.supcon.common.view.view.loader.cycler.CircularAnimatedDrawable;
import com.supcon.common.view.view.loader.cycler.CircularRevealAnimatedDrawable;
import com.supcon.common.view.view.loader.cycler.OnAnimationEndListener;

public class CircularLoaderView
extends AppCompatImageButton {
    private GradientDrawable mGradientDrawable;
    private boolean mIsMorphingInProgress;
    private State mState;
    private CircularAnimatedDrawable mAnimatedDrawable;
    private CircularRevealAnimatedDrawable mRevealDrawable;
    private AnimatorSet mMorphingAnimatorSet;
    private Drawable mSrc;
    private int mFillColorDone;
    private Bitmap mBitmapDone;
    private Params mParams;
    private boolean doneWhileMorphing;

    public CircularLoaderView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public CircularLoaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public CircularLoaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=23)
    public CircularLoaderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mParams = new Params();
        this.mParams.mPaddingProgress = Float.valueOf(0.0f);
        if (attrs == null) {
            this.mGradientDrawable = (GradientDrawable)this.getDrawable(this.getContext(), R.drawable.sh_loader_default);
        } else {
            TypedArray typedArrayBG;
            TypedArray typedArray;
            block7: {
                int[] attrsArray = new int[]{16842964};
                typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircularLoaderView, defStyleAttr, defStyleRes);
                typedArrayBG = context.obtainStyledAttributes(attrs, attrsArray, defStyleAttr, defStyleRes);
                try {
                    this.mGradientDrawable = (GradientDrawable)typedArrayBG.getDrawable(0);
                }
                catch (ClassCastException e) {
                    Drawable drawable2 = typedArrayBG.getDrawable(0);
                    if (drawable2 instanceof ColorDrawable) {
                        ColorDrawable colorDrawable = (ColorDrawable)drawable2;
                        this.mGradientDrawable = new GradientDrawable();
                        this.mGradientDrawable.setColor(colorDrawable.getColor());
                    }
                    if (!(drawable2 instanceof StateListDrawable)) break block7;
                    StateListDrawable stateListDrawable = (StateListDrawable)drawable2;
                    try {
                        this.mGradientDrawable = (GradientDrawable)stateListDrawable.getCurrent();
                    }
                    catch (ClassCastException e1) {
                        throw new RuntimeException("Error reading background... Use a shape or a color in xml!", e1.getCause());
                    }
                }
            }
            this.mParams.mInitialCornerRadius = typedArray.getDimension(R.styleable.CircularLoaderView_initialCornerAngle, 0.0f);
            this.mParams.mFinalCornerRadius = typedArray.getDimension(R.styleable.CircularLoaderView_finalCornerAngle, 100.0f);
            this.mParams.mSpinningBarWidth = typedArray.getDimension(R.styleable.CircularLoaderView_spinning_bar_width, 10.0f);
            this.mParams.mSpinningBarColor = typedArray.getColor(R.styleable.CircularLoaderView_spinning_bar_color, this.getColorWrapper(context, 17170444));
            this.mParams.mPaddingProgress = Float.valueOf(typedArray.getDimension(R.styleable.CircularLoaderView_spinning_bar_padding, 0.0f));
            typedArray.recycle();
            typedArrayBG.recycle();
        }
        this.mState = State.IDLE;
        this.setBackground((Drawable)this.mGradientDrawable);
    }

    public void setBackgroundColor(int color2) {
        this.mGradientDrawable.setColor(color2);
    }

    public void setBackgroundResource(@ColorRes int resid) {
        this.mGradientDrawable.setColor(ContextCompat.getColor((Context)this.getContext(), (int)resid));
    }

    public void setSpinningBarColor(int color2) {
        this.mParams.mSpinningBarColor = color2;
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.setLoadingBarColor(color2);
        }
    }

    public void setSpinningBarWidth(float width) {
        this.mParams.mSpinningBarWidth = width;
    }

    public void setDoneColor(int color2) {
        this.mParams.mDoneColor = color2;
    }

    public void setPaddingProgress(float padding) {
        this.mParams.mPaddingProgress = Float.valueOf(padding);
    }

    public void setInitialHeight(int height) {
        this.mParams.mInitialHeight = height;
    }

    public void setInitialCornerRadius(float radius) {
        this.mParams.mInitialCornerRadius = radius;
    }

    public void setFinalCornerRadius(float radius) {
        this.mParams.mFinalCornerRadius = radius;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mState == State.PROGRESS && !this.mIsMorphingInProgress) {
            this.drawIndeterminateProgress(canvas);
        } else if (this.mState == State.DONE) {
            this.drawDoneAnimation(canvas);
        }
    }

    private void drawIndeterminateProgress(Canvas canvas) {
        if (this.mAnimatedDrawable == null || !this.mAnimatedDrawable.isRunning()) {
            this.mAnimatedDrawable = new CircularAnimatedDrawable((View)this, this.mParams.mSpinningBarWidth, this.mParams.mSpinningBarColor);
            int offset = (this.getWidth() - this.getHeight()) / 2;
            int left = offset + this.mParams.mPaddingProgress.intValue();
            int right = this.getWidth() - offset - this.mParams.mPaddingProgress.intValue();
            int bottom = this.getHeight() - this.mParams.mPaddingProgress.intValue();
            int top = this.mParams.mPaddingProgress.intValue();
            this.mAnimatedDrawable.setBounds(left, top, right, bottom);
            this.mAnimatedDrawable.setCallback((Drawable.Callback)this);
            this.mAnimatedDrawable.start();
        } else {
            this.mAnimatedDrawable.draw(canvas);
        }
    }

    public void stopAnimation() {
        if (this.mState == State.PROGRESS && !this.mIsMorphingInProgress) {
            this.mState = State.STOPED;
            this.mAnimatedDrawable.stop();
        }
    }

    public void doneLoadingAnimation(int fillColor, Bitmap bitmap) {
        if (this.mState != State.PROGRESS) {
            return;
        }
        if (this.mIsMorphingInProgress) {
            this.doneWhileMorphing = true;
            this.mFillColorDone = fillColor;
            this.mBitmapDone = bitmap;
            return;
        }
        this.mState = State.DONE;
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.stop();
        }
        this.mRevealDrawable = new CircularRevealAnimatedDrawable((View)this, fillColor, bitmap);
        int left = 0;
        int right = this.getWidth();
        int bottom = this.getHeight();
        int top = 0;
        this.mRevealDrawable.setBounds(left, top, right, bottom);
        this.mRevealDrawable.setCallback((Drawable.Callback)this);
        this.mRevealDrawable.start();
    }

    private void drawDoneAnimation(Canvas canvas) {
        this.mRevealDrawable.draw(canvas);
    }

    public void revertAnimation() {
        this.revertAnimation(null);
    }

    public void revertAnimation(final OnAnimationEndListener onAnimationEndListener) {
        this.mState = State.IDLE;
        if (this.mAnimatedDrawable != null && this.mAnimatedDrawable.isRunning()) {
            this.stopAnimation();
        }
        if (this.mIsMorphingInProgress) {
            this.mMorphingAnimatorSet.cancel();
        }
        this.setClickable(false);
        int fromWidth = this.getWidth();
        int fromHeight = this.getHeight();
        int toHeight = this.mParams.mInitialHeight;
        int toWidth = this.mParams.mInitialWidth;
        ObjectAnimator cornerAnimation = ObjectAnimator.ofFloat((Object)this.mGradientDrawable, (String)"cornerRadius", (float[])new float[]{this.mParams.mFinalCornerRadius, this.mParams.mInitialCornerRadius});
        ValueAnimator widthAnimation = ValueAnimator.ofInt((int[])new int[]{fromWidth, toWidth});
        widthAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CircularLoaderView.this.getLayoutParams();
                layoutParams.width = val;
                CircularLoaderView.this.setLayoutParams(layoutParams);
            }
        });
        ValueAnimator heightAnimation = ValueAnimator.ofInt((int[])new int[]{fromHeight, toHeight});
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CircularLoaderView.this.getLayoutParams();
                layoutParams.height = val;
                CircularLoaderView.this.setLayoutParams(layoutParams);
            }
        });
        this.mMorphingAnimatorSet = new AnimatorSet();
        this.mMorphingAnimatorSet.setDuration(300L);
        this.mMorphingAnimatorSet.playTogether(new Animator[]{cornerAnimation, widthAnimation, heightAnimation});
        this.mMorphingAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CircularLoaderView.this.setImageDrawable(CircularLoaderView.this.mSrc);
                CircularLoaderView.this.setClickable(true);
                CircularLoaderView.this.mIsMorphingInProgress = false;
                if (onAnimationEndListener != null) {
                    onAnimationEndListener.onAnimationEnd();
                }
            }
        });
        this.mIsMorphingInProgress = true;
        this.mMorphingAnimatorSet.start();
    }

    public void dispose() {
        if (this.mMorphingAnimatorSet != null) {
            this.mMorphingAnimatorSet.end();
            this.mMorphingAnimatorSet.removeAllListeners();
            this.mMorphingAnimatorSet.cancel();
        }
        this.mMorphingAnimatorSet = null;
    }

    public void startAnimation() {
        int toHeight;
        if (this.mState != State.IDLE) {
            return;
        }
        if (this.mIsMorphingInProgress) {
            this.mMorphingAnimatorSet.cancel();
        } else {
            this.mParams.mInitialWidth = this.getWidth();
            this.mParams.mInitialHeight = this.getHeight();
        }
        this.mState = State.PROGRESS;
        this.mSrc = this.getDrawable();
        this.setImageDrawable(null);
        this.setClickable(false);
        int toWidth = toHeight = this.mParams.mInitialHeight;
        ObjectAnimator cornerAnimation = ObjectAnimator.ofFloat((Object)this.mGradientDrawable, (String)"cornerRadius", (float[])new float[]{this.mParams.mInitialCornerRadius, this.mParams.mFinalCornerRadius});
        ValueAnimator widthAnimation = ValueAnimator.ofInt((int[])new int[]{this.mParams.mInitialWidth, toWidth});
        widthAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CircularLoaderView.this.getLayoutParams();
                layoutParams.width = val;
                CircularLoaderView.this.setLayoutParams(layoutParams);
            }
        });
        ValueAnimator heightAnimation = ValueAnimator.ofInt((int[])new int[]{this.mParams.mInitialHeight, toHeight});
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CircularLoaderView.this.getLayoutParams();
                layoutParams.height = val;
                CircularLoaderView.this.setLayoutParams(layoutParams);
            }
        });
        this.mMorphingAnimatorSet = new AnimatorSet();
        this.mMorphingAnimatorSet.setDuration(300L);
        this.mMorphingAnimatorSet.playTogether(new Animator[]{cornerAnimation, widthAnimation, heightAnimation});
        this.mMorphingAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CircularLoaderView.this.mIsMorphingInProgress = false;
                if (CircularLoaderView.this.doneWhileMorphing) {
                    CircularLoaderView.this.doneWhileMorphing = false;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            CircularLoaderView.this.doneLoadingAnimation(CircularLoaderView.this.mFillColorDone, CircularLoaderView.this.mBitmapDone);
                        }
                    };
                    new Handler().postDelayed(runnable, 50L);
                }
            }
        });
        this.mIsMorphingInProgress = true;
        this.mMorphingAnimatorSet.start();
    }

    public Drawable getDrawable(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id2);
        }
        return context.getResources().getDrawable(id2);
    }

    public int getColorWrapper(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColor(id2);
        }
        return context.getResources().getColor(id2);
    }

    private class Params {
        private float mSpinningBarWidth;
        private int mSpinningBarColor;
        private int mDoneColor;
        private Float mPaddingProgress;
        private int mInitialHeight;
        private int mInitialWidth;
        private float mInitialCornerRadius;
        private float mFinalCornerRadius;

        private Params() {
        }
    }

    private static enum State {
        PROGRESS,
        IDLE,
        DONE,
        STOPED;

    }
}

