/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.presenter;

import com.supcon.common.view.contract.IBasePresenter;
import com.supcon.common.view.contract.IBaseView;
import io.reactivex.disposables.CompositeDisposable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class BasePresenter<V extends IBaseView>
implements IBasePresenter<V> {
    private WeakReference<V> mViewRef;
    protected CompositeDisposable mCompositeSubscription = new CompositeDisposable();
    private V mProxyView;

    protected void onAttached() {
    }

    protected void onDetached() {
    }

    protected boolean isViewAttached() {
        return this.mViewRef != null && this.mViewRef.get() != null;
    }

    @Override
    public void attachView(V v) {
        this.mViewRef = new WeakReference<V>(v);
        this.onAttached();
        MvpViewHandler viewHandler = new MvpViewHandler((IBaseView)v);
        this.mProxyView = (IBaseView)Proxy.newProxyInstance(v.getClass().getClassLoader(), v.getClass().getInterfaces(), (InvocationHandler)viewHandler);
    }

    @Override
    public V getView() {
        return this.mProxyView;
    }

    @Override
    public void detachView() {
        this.mCompositeSubscription.dispose();
        if (this.mViewRef != null) {
            this.mViewRef.clear();
            this.mViewRef = null;
        }
        this.onDetached();
    }

    private class MvpViewHandler
    implements InvocationHandler {
        private IBaseView mvpView;

        MvpViewHandler(IBaseView mvpView) {
            this.mvpView = mvpView;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (BasePresenter.this.isViewAttached()) {
                return method.invoke((Object)this.mvpView, args);
            }
            return null;
        }
    }
}

