/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.adapter;

import android.content.Context;
import com.supcon.common.view.base.adapter.BaseAdapter;
import com.supcon.common.view.base.adapter.IListAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListViewAdapter<T>
extends BaseAdapter<T>
implements IListAdapter<T> {
    protected List<T> list;

    public BaseListViewAdapter(Context context) {
        super(context);
    }

    public BaseListViewAdapter(Context context, List<T> list) {
        super(context);
        this.list = list;
    }

    @Override
    public void setList(List<T> list) {
        this.list = list;
    }

    public int getCount() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    @Override
    public T getItem(int i) {
        if (this.list != null && i >= 0 && i < this.list.size()) {
            return this.list.get(i);
        }
        return null;
    }

    public long getItemId(int i) {
        return 0L;
    }

    @Override
    public List<T> getList() {
        return this.list;
    }

    @Override
    public void addData(T t) {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        this.list.add(t);
    }

    @Override
    public void addList(List<T> list) {
        if (this.list == null) {
            this.list = list;
        } else if (list != null) {
            this.list.addAll(list);
        }
    }

    @Override
    public void remove(int index) {
        if (this.list != null && index >= 0 && this.list.size() > index) {
            this.list.remove(index);
        }
    }

    @Override
    public void remove(T t) {
        for (int i = 0; this.list != null && i < this.list.size(); ++i) {
            if (!this.compareEqual(this.list.get(i), t)) continue;
            this.list.remove(i);
            break;
        }
    }

    @Override
    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    protected boolean compareEqual(T t1, T t2) {
        if (t1 != null && t2 != null) {
            return t1.equals(t2);
        }
        return false;
    }
}

