/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.supcon.common.view.R;
import com.supcon.common.view.base.activity.BaseActivity;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.ToastUtils;
import com.supcon.common.view.util.UriUtil;
import com.supcon.common.view.util.UrlUtil;
import com.supcon.common.view.view.js.BridgeHandler;
import com.supcon.common.view.view.js.BridgeWebView;
import com.supcon.common.view.view.js.CallBackFunction;
import com.supcon.common.view.view.js.DefaultHandler;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseWebViewActivity
extends BaseActivity {
    protected BridgeWebView webView;
    protected ProgressBar pbProgress;
    protected TextView titleText;
    protected ImageButton leftBtn;
    protected ImageButton rightBtn;
    private String url;
    private String cookie;
    private String authorization;
    private boolean isDialog = false;
    private boolean hasRefresh = false;
    protected boolean isList = false;
    protected long pendingId;
    private boolean isPendingRefresh = false;
    private static final int RESULT_CODE = 0;
    private ValueCallback<Uri> mUploadMessage;
    private CallBackFunction mFileCallBackFunction;

    @Override
    protected void onInit() {
        super.onInit();
        this.url = this.getIntent().getStringExtra("WEB_URL");
        this.cookie = this.getIntent().getStringExtra("WEB_COOKIE");
        this.authorization = this.getIntent().getStringExtra("WEB_AUTHORIZATION");
        this.hasRefresh = this.getIntent().getBooleanExtra("WEB_HAS_REFRESH", false);
        this.isList = this.getIntent().getBooleanExtra("WEB_IS_LIST", false);
        if (TextUtils.isEmpty((CharSequence)this.url) || TextUtils.isEmpty((CharSequence)this.cookie) || TextUtils.isEmpty((CharSequence)this.authorization)) {
            throw new IllegalArgumentException("\u4f20\u53c2\u9519\u8bef\uff01");
        }
        LogUtil.i("Url:" + this.url + "\nCookie:" + this.cookie + "\nAuthorization\uff1a" + this.authorization);
        this.pendingId = UrlUtil.parseIdFormUrl(this.url, "pendingId");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void initView() {
        super.initView();
        this.webView = (BridgeWebView)this.rootView.findViewWithTag((Object)"webview");
        this.pbProgress = (ProgressBar)this.rootView.findViewWithTag((Object)"pb_progress");
        this.titleText = (TextView)this.rootView.findViewWithTag((Object)"titleText");
        this.leftBtn = (ImageButton)this.rootView.findViewWithTag((Object)"leftBtn");
        this.rightBtn = (ImageButton)this.rootView.findViewWithTag((Object)"rightBtn");
        if (this.rightBtn != null && this.hasRefresh) {
            this.rightBtn.setImageResource(R.drawable.sl_top_refresh);
            this.rightBtn.setVisibility(0);
        }
        this.initWebView();
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.webView.registerHandler("close", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("close" + data);
                BaseWebViewActivity.this.back();
            }
        });
        this.webView.registerHandler("showSubmit", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("showSubmit" + data);
            }
        });
        this.webView.registerHandler("setTitle", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("setTitle" + data);
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        BaseWebViewActivity.this.titleText.setText((CharSequence)jsonObject.getString("param"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.webView.registerHandler("onloadStart", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("onloadStart" + data);
            }
        });
        this.webView.registerHandler("onloadEnd", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("onloadEnd" + data);
            }
        });
        this.webView.registerHandler("pendingRefresh", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("pendingRefresh" + data);
                BaseWebViewActivity.this.isPendingRefresh = true;
            }
        });
        this.webView.registerHandler("supmobileReload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("supmobileReload" + data);
                ToastUtils.show(BaseWebViewActivity.this.context, "\u767b\u9646\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
            }
        });
        this.webView.registerHandler("openDialog", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("openDialog" + data);
                BaseWebViewActivity.this.setIsDialog(true);
            }
        });
        this.webView.registerHandler("closeDialog", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("closeDialog" + data);
                BaseWebViewActivity.this.setIsDialog(false);
            }
        });
        this.webView.registerHandler("supconUpload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("supconUpload" + data);
                BaseWebViewActivity.this.pickFile();
                BaseWebViewActivity.this.mFileCallBackFunction = function;
            }
        });
        this.webView.registerHandler("mobileReload", new BridgeHandler(){

            @Override
            public void handler(String data, CallBackFunction function) {
                LogUtil.i("mobileReload" + data);
                BaseWebViewActivity.this.webView.reload();
            }
        });
        if (this.leftBtn != null) {
            this.leftBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseWebViewActivity.this.onBackPressed();
                }
            });
        }
        if (this.rightBtn != null) {
            this.rightBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseWebViewActivity.this.onReload();
                }
            });
        }
    }

    protected void onReload() {
        this.webView.reload();
    }

    public void setPendingRefresh(boolean pendingRefresh) {
        this.isPendingRefresh = pendingRefresh;
    }

    @Override
    protected void initData() {
        super.initData();
        HashMap<String, String> header = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.cookie)) {
            header.put("Cookie", this.cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)this.authorization)) {
            header.put("Authorization", this.authorization);
        }
        this.webView.loadUrl(this.url, header);
    }

    private void initWebView() {
        if (this.webView == null) {
            throw new IllegalArgumentException("BridgeWebView is null!");
        }
        this.webView.setDefaultHandler(new DefaultHandler());
        WebSettings settings = this.webView.getSettings();
        settings.setAppCacheEnabled(true);
        settings.setJavaScriptEnabled(true);
        settings.setAllowFileAccess(true);
        settings.setDatabaseEnabled(true);
        String dir = this.getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabasePath(dir);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        this.setWebChromeClient(new DefaultWebChromeClient());
    }

    protected void setWebChromeClient(WebChromeClient webChromeClient) {
        this.webView.setWebChromeClient(webChromeClient);
    }

    protected void callJSFunction(final String jsFunctionName, String data) {
        this.webView.callHandler(jsFunctionName, data, new CallBackFunction(){

            @Override
            public void onCallBack(String data) {
                LogUtil.i("function:" + jsFunctionName + " onCallBack data = " + data);
            }
        });
    }

    protected void registerHandler(String name, BridgeHandler handler) {
        this.webView.registerHandler(name, handler);
    }

    protected void sendMessageToJs(String message) {
        this.webView.send(message, new CallBackFunction(){

            @Override
            public void onCallBack(String data) {
                LogUtil.i("sendMessageToJs onCallBack data = " + data);
            }
        });
    }

    @Override
    public void onBackPressed() {
        if (this.isDialog) {
            return;
        }
        if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    public void setTitle(String title) {
        if (this.titleText != null) {
            this.titleText.setText((CharSequence)title);
        }
    }

    public void setIsDialog(boolean isDialog) {
        this.isDialog = isDialog;
        if (isDialog) {
            ((ViewGroup)this.titleText.getParent()).setVisibility(8);
        } else {
            ((ViewGroup)this.titleText.getParent()).setVisibility(0);
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void loginValid() {
        if (this.isList) {
            this.webView.reload();
        } else {
            ToastUtils.show(this.context, "\u9875\u9762\u5df2\u5931\u6548");
            Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    BaseWebViewActivity.this.back();
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void unauthorized() {
        ToastUtils.show(this.context, "\u9875\u9762\u5df2\u5931\u6548");
        Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                BaseWebViewActivity.this.back();
            }
        });
    }

    public void serverError() {
        ToastUtils.show(this.context, "\u670d\u52a1\u5668\u9519\u8bef");
    }

    public void sendRefreshEvent() {
    }

    public void next(String url) {
        this.goNext(url);
    }

    public boolean checkUrl(String inUrl) {
        long newPendingId = UrlUtil.parseIdFormUrl(inUrl, "pendingId");
        long deploymentId = UrlUtil.parseIdFormUrl(inUrl, "deploymentId");
        return this.pendingId != 0L && newPendingId != 0L && this.pendingId == newPendingId || deploymentId != 0L && newPendingId == 0L && this.isPendingRefresh;
    }

    protected void goNext(String url) {
    }

    public void pickFile() {
        Intent chooserIntent = new Intent("android.intent.action.GET_CONTENT");
        chooserIntent.setType("*/*");
        this.startActivityForResult(chooserIntent, 0);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 0) {
            Uri result;
            Uri uri = result = intent == null || resultCode != -1 ? null : intent.getData();
            if (result == null) {
                return;
            }
            if (null != this.mUploadMessage) {
                this.mUploadMessage.onReceiveValue((Object)result);
                this.mUploadMessage = null;
            } else if (this.mFileCallBackFunction != null) {
                String path = UriUtil.getFilePathByUri(this.context, result);
                if (TextUtils.isEmpty((CharSequence)path)) {
                    return;
                }
                this.uploadFile(new File(path), this.mFileCallBackFunction);
            }
        }
    }

    protected void uploadFile(File file, CallBackFunction callBackFunction) {
    }

    protected void showDialog(String message, JsResult result) {
    }

    public class DefaultWebChromeClient
    extends WebChromeClient {
        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType, String capture) {
            this.openFileChooser(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType) {
            this.openFileChooser(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            BaseWebViewActivity.this.mUploadMessage = uploadMsg;
            BaseWebViewActivity.this.pickFile();
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress == 100) {
                BaseWebViewActivity.this.pbProgress.setVisibility(8);
            } else {
                BaseWebViewActivity.this.pbProgress.setVisibility(0);
                BaseWebViewActivity.this.pbProgress.setProgress(newProgress);
            }
            super.onProgressChanged(view, newProgress);
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            LogUtil.d("onCreateWindow");
            return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        public void onHideCustomView() {
            super.onHideCustomView();
            LogUtil.d("onHideCustomView");
        }

        public void onCloseWindow(WebView window) {
            super.onCloseWindow(window);
            LogUtil.d("onCloseWindow");
        }

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            if (!TextUtils.isEmpty((CharSequence)title) && title.length() > 10) {
                return;
            }
            LogUtil.d("onReceivedTitle:" + title);
            BaseWebViewActivity.this.setTitle(title);
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            LogUtil.d("onShowCustomView");
        }

        public void onRequestFocus(WebView view) {
            super.onRequestFocus(view);
            LogUtil.d("onRequestFocus");
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            BaseWebViewActivity.this.showDialog(message, result);
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            BaseWebViewActivity.this.showDialog(message, result);
            return true;
        }
    }
}

