/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.activity;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.View;
import com.app.annotation.Controller;
import com.app.annotation.Presenter;
import com.supcon.common.com_router.router.PresenterRouter;
import com.supcon.common.view.Lifecycle;
import com.supcon.common.view.LifecycleManage;
import com.supcon.common.view.base.activity.BaseFragmentActivity;
import com.supcon.common.view.base.controller.BaseController;
import com.supcon.common.view.base.fragment.BaseFragment;
import com.supcon.common.view.base.presenter.BasePresenter;
import com.supcon.common.view.contract.IBaseView;
import com.supcon.common.view.util.InstanceUtil;
import com.supcon.common.view.util.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseMultiFragmentActivity
extends BaseFragmentActivity {
    public int selectIndex = -1;
    public List<BaseFragment> fragments = new ArrayList<BaseFragment>();
    protected PresenterRouter presenterRouter;
    private List<BasePresenter> mPresenters = new ArrayList<BasePresenter>();
    protected LifecycleManage controllers = new LifecycleManage();
    protected List<BaseController> dataControllers = new ArrayList<BaseController>();

    protected void initPresenter() {
        Annotation[] annotations;
        this.presenterRouter = new PresenterRouter();
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            Class[] presenters;
            if (!(annotation instanceof Presenter)) continue;
            for (Class presenter : presenters = ((Presenter)annotation).value()) {
                if (!(this instanceof IBaseView)) continue;
                BasePresenter basePresenter = (BasePresenter)InstanceUtil.getInstance(presenter);
                this.presenterRouter.register((Object)basePresenter);
                this.addPresenter(basePresenter);
                LogUtil.d("presenter " + presenter.getName() + " added!");
            }
        }
    }

    private void addPresenter(BasePresenter basePresenter) {
        basePresenter.attachView(this);
        this.mPresenters.add(basePresenter);
    }

    protected void initControllers() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            Class[] controllerClasses;
            if (!(annotation instanceof Controller)) continue;
            for (Class controller : controllerClasses = ((Controller)annotation).value()) {
                try {
                    Constructor constructor = null;
                    BaseController baseController = null;
                    if (controller.getSuperclass().getSimpleName().equals("BasePresenterController")) {
                        constructor = controller.getConstructor(new Class[0]);
                        baseController = (BaseController)constructor.newInstance(new Object[0]);
                    } else if (controller.getSuperclass().getSimpleName().equals("BaseDataController")) {
                        constructor = controller.getConstructor(Context.class);
                        baseController = (BaseController)constructor.newInstance(this.context);
                    } else if (controller.getSuperclass().getSimpleName().equals("BaseViewController")) {
                        constructor = controller.getConstructor(View.class);
                        baseController = (BaseController)constructor.newInstance(this.rootView);
                    } else {
                        constructor = controller.getConstructor(View.class);
                        baseController = (BaseController)constructor.newInstance(this.rootView);
                    }
                    if (baseController == null) continue;
                    LogUtil.d("controller " + controller.getName() + " added!");
                    this.registerController(controller.getSimpleName(), baseController);
                    this.addDataController(baseController);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void addDataController(BaseController baseController) {
        this.dataControllers.add(baseController);
    }

    protected void registerController(String key, Lifecycle controller) {
        if (!TextUtils.isEmpty((CharSequence)key) && controller != null) {
            this.controllers.register(key, controller);
        }
    }

    public <T extends Lifecycle> T getController(Class<T> clazz) {
        return (T)this.controllers.get(clazz.getSimpleName());
    }

    public Lifecycle getController(String key) {
        return this.controllers.get(key);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.initPresenter();
        this.initControllers();
        this.onRegisterController();
        this.controllers.onInit();
    }

    protected void onRegisterController() {
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.controllers.initListener();
    }

    @Override
    protected void initData() {
        super.initData();
        this.controllers.initData();
    }

    protected void onPause() {
        super.onPause();
        this.controllers.onPause();
    }

    protected void onStart() {
        super.onStart();
        this.controllers.onStart();
    }

    protected void onStop() {
        super.onStop();
        this.controllers.onStop();
    }

    protected void onResume() {
        super.onResume();
        this.controllers.onResume();
    }

    public void onRetry() {
        this.controllers.onRetry();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.controllers.onDestroy();
        for (BasePresenter presenter : this.mPresenters) {
            if (presenter == null) continue;
            presenter.detachView();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        for (BaseController baseController : this.dataControllers) {
            baseController.refresh();
        }
    }

    @Override
    public boolean checkBeforeSubmit(Map<String, Object> map) {
        for (BaseController baseController : this.dataControllers) {
            if (baseController.checkBeforeSubmit(map)) continue;
            return false;
        }
        return super.checkBeforeSubmit(map);
    }

    @Override
    public boolean doSave(Map<String, Object> map) {
        for (BaseController baseController : this.dataControllers) {
            if (baseController.doSave(map)) continue;
            return false;
        }
        return super.doSave(map);
    }

    @Override
    public boolean isModified() {
        for (BaseController baseController : this.dataControllers) {
            boolean isModified = baseController.isModified();
            if (!isModified) continue;
            return true;
        }
        return super.isModified();
    }

    @IdRes
    public abstract int getFragmentContainerId();

    public abstract void createFragments();

    @Override
    protected void initView() {
        super.initView();
        this.controllers.initView();
        this.createFragments();
    }

    public void showFragment(int selectIndex) {
        FragmentTransaction addTransaction = this.fragmentManager.beginTransaction();
        if (this.fragmentManager.getFragments() == null || this.fragments.size() > selectIndex && !this.fragmentManager.getFragments().contains(this.fragments.get(selectIndex))) {
            addTransaction.add(this.getFragmentContainerId(), (Fragment)this.fragments.get(selectIndex), String.format("fragment_%s", selectIndex));
            addTransaction.commitAllowingStateLoss();
        }
        this.showFragmentIndex(selectIndex);
    }

    private void showFragmentIndex(int selectIndex) {
        if (this.fragments != null && this.fragments.size() > selectIndex && this.selectIndex != selectIndex) {
            this.selectIndex = selectIndex;
            FragmentTransaction showTranscation = this.fragmentManager.beginTransaction();
            for (Fragment fragment : this.fragments) {
                showTranscation.hide(fragment);
            }
            showTranscation.show((Fragment)this.fragments.get(selectIndex));
            showTranscation.commitAllowingStateLoss();
        }
    }

    protected void pushFragmentToContainer(int resId, BaseFragment fragment) {
        if (resId > 0 && fragment != null) {
            FragmentTransaction addTransaction = this.fragmentManager.beginTransaction();
            addTransaction.add(resId, (Fragment)fragment);
            addTransaction.commitAllowingStateLoss();
        }
    }
}

